/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.Gems.Listeners;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import java.util.Objects;
import ne.fnfal113.fnamplifications.Gems.ArmorImpairGem;
import ne.fnfal113.fnamplifications.Gems.HastyGem;
import ne.fnfal113.fnamplifications.Gems.ImpostorGem;
import ne.fnfal113.fnamplifications.Gems.InfernoGem;
import ne.fnfal113.fnamplifications.Gems.TelepathyGem;
import ne.fnfal113.fnamplifications.Gems.ThornAwayGem;
import ne.fnfal113.fnamplifications.Gems.ThunderBoltGem;
import org.apache.commons.lang.Validate;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Container;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class GemListener
implements Listener {
    @EventHandler
    public void onDragDrop(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        if (event.getAction() != InventoryAction.SWAP_WITH_CURSOR) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        SlimefunItem gem = SlimefunItem.getByItem((ItemStack)event.getCursor());
        if (gem instanceof InfernoGem) {
            ((InfernoGem)gem).onDrag(event, player);
        } else if (gem instanceof ArmorImpairGem) {
            ((ArmorImpairGem)gem).onDrag(event, player);
        } else if (gem instanceof TelepathyGem) {
            ((TelepathyGem)gem).onDrag(event, player);
        } else if (gem instanceof ThunderBoltGem) {
            ((ThunderBoltGem)gem).onDrag(event, player);
        } else if (gem instanceof HastyGem) {
            ((HastyGem)gem).onDrag(event, player);
        } else if (gem instanceof ThornAwayGem) {
            ((ThornAwayGem)gem).onDrag(event, player);
        } else if (gem instanceof ImpostorGem) {
            ((ImpostorGem)gem).onDrag(event, player);
        }
    }

    @EventHandler
    public void onEntityDamage(EntityDamageByEntityEvent event) {
        SlimefunItem item;
        ItemStack itemStackHand;
        PersistentDataContainer pdcHand;
        Player player;
        if (!(event.getEntity() instanceof LivingEntity)) {
            return;
        }
        if (event.getDamager() instanceof Player && event.getCause() == EntityDamageEvent.DamageCause.ENTITY_ATTACK && (player = (Player)event.getDamager()).getInventory().getItemInMainHand().getType() != Material.AIR && !(pdcHand = this.getPersistentDataContainer(itemStackHand = player.getInventory().getItemInMainHand())).isEmpty()) {
            for (NamespacedKey key : pdcHand.getKeys()) {
                if (!pdcHand.has(key, PersistentDataType.STRING)) continue;
                item = SlimefunItem.getById((String)Objects.requireNonNull((String)pdcHand.get(key, PersistentDataType.STRING)));
                if (item instanceof InfernoGem) {
                    ((InfernoGem)item).onDamage(event);
                }
                if (item instanceof ArmorImpairGem) {
                    ((ArmorImpairGem)item).onDamage(event);
                }
                if (!(item instanceof ThunderBoltGem)) continue;
                ((ThunderBoltGem)item).onDamage(event, player);
            }
        }
        if (event.getEntity() instanceof Player) {
            ItemStack itemStackHelmet;
            PersistentDataContainer pdcHelmet;
            ItemStack itemStackChest;
            PersistentDataContainer pdcChest;
            player = (Player)event.getEntity();
            if (player.getInventory().getChestplate() != null && !(pdcChest = this.getPersistentDataContainer(itemStackChest = player.getInventory().getChestplate())).isEmpty()) {
                for (NamespacedKey key : pdcChest.getKeys()) {
                    if (!pdcChest.has(key, PersistentDataType.STRING) || !((item = SlimefunItem.getById((String)Objects.requireNonNull((String)pdcChest.get(key, PersistentDataType.STRING)))) instanceof ThornAwayGem)) continue;
                    ((ThornAwayGem)item).onDamage((EntityDamageEvent)event);
                }
            }
            if (player.getInventory().getHelmet() != null && !(pdcHelmet = this.getPersistentDataContainer(itemStackHelmet = player.getInventory().getHelmet())).isEmpty()) {
                for (NamespacedKey key : pdcHelmet.getKeys()) {
                    if (!pdcHelmet.has(key, PersistentDataType.STRING) || !((item = SlimefunItem.getById((String)Objects.requireNonNull((String)pdcHelmet.get(key, PersistentDataType.STRING)))) instanceof ImpostorGem)) continue;
                    ((ImpostorGem)item).onDamage(event);
                }
            }
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        if (player.getGameMode() == GameMode.CREATIVE || player.getGameMode() == GameMode.SPECTATOR) {
            return;
        }
        if (event.getBlock().getState() instanceof Container) {
            return;
        }
        if (player.getInventory().getItemInMainHand().getType() == Material.AIR) {
            return;
        }
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        PersistentDataContainer pdc = this.getPersistentDataContainer(itemStack);
        if (!pdc.isEmpty()) {
            for (NamespacedKey key : pdc.getKeys()) {
                if (!pdc.has(key, PersistentDataType.STRING)) continue;
                SlimefunItem item = SlimefunItem.getById((String)Objects.requireNonNull((String)pdc.get(key, PersistentDataType.STRING)));
                if (item instanceof TelepathyGem) {
                    ((TelepathyGem)item).onBlockBreak(event, player);
                }
                if (!(item instanceof HastyGem)) continue;
                ((HastyGem)item).onBlockBreak(event, player);
            }
        }
    }

    public PersistentDataContainer getPersistentDataContainer(ItemStack itemStack) {
        ItemMeta meta = itemStack.getItemMeta();
        Validate.notNull((Object)meta, (String)"Meta must not be null!");
        return meta.getPersistentDataContainer();
    }
}

