/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.tools.implementation;

import java.util.Objects;
import ne.fnfal113.fnamplifications.utils.Utils;
import org.bukkit.Material;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Consumer;
import org.bukkit.util.Vector;

public class ThrowableItemTask
extends BukkitRunnable {
    private final Player player;
    private final ItemStack itemStack;
    private final Vector vector;
    private final ArmorStand armorStand;
    private final Consumer<ThrowableItemTask> throwableItemTaskConsumer;

    public ThrowableItemTask(Player player, ItemStack itemStack, Vector vector, Consumer<ThrowableItemTask> throwableItemTaskConsumer) {
        this.player = player;
        this.itemStack = itemStack.clone();
        this.vector = vector;
        this.armorStand = this.spawnArmorstand();
        this.throwableItemTaskConsumer = throwableItemTaskConsumer;
    }

    public ArmorStand spawnArmorstand() {
        ArmorStand as = (ArmorStand)this.getPlayer().getWorld().spawn(this.getPlayer().getLocation().add(0.0, 0.9, 0.0), ArmorStand.class);
        as.setArms(true);
        as.setSmall(true);
        as.setMarker(true);
        as.setGravity(false);
        as.setVisible(false);
        as.setCustomNameVisible(false);
        as.setPersistent(false);
        as.setBasePlate(false);
        as.setRightArmPose(Utils.setRightArmAngle(as, 270, 0, 0));
        Objects.requireNonNull(as.getEquipment()).setItemInMainHand(this.getItemStack().clone());
        return as;
    }

    public void run() {
        this.getThrowableItemTaskConsumer().accept((Object)this);
    }

    public void dropTorch() {
        if (this.getItemStack() != null && this.getItemStack().getType() != Material.AIR) {
            this.getItemStack().setAmount(1);
            Item droppedItem = this.getArmorStand().getWorld().dropItemNaturally(this.getArmorStand().getLocation(), this.getItemStack());
            droppedItem.setGlowing(true);
        }
        this.stopTask();
    }

    public void stopTask() {
        this.getArmorStand().remove();
        this.cancel();
    }

    public Player getPlayer() {
        return this.player;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public Vector getVector() {
        return this.vector;
    }

    public ArmorStand getArmorStand() {
        return this.armorStand;
    }

    public Consumer<ThrowableItemTask> getThrowableItemTaskConsumer() {
        return this.throwableItemTaskConsumer;
    }
}

