/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.gems.listener;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import ne.fnfal113.fnamplifications.gems.abstracts.AbstractGem;
import ne.fnfal113.fnamplifications.gems.abstracts.AbstractGemUnbinder;
import ne.fnfal113.fnamplifications.gems.implementation.GemUnbinderTask;
import ne.fnfal113.fnamplifications.utils.Utils;
import ne.fnfal113.fnamplifications.utils.compatibility.VersionedClass;
import org.bukkit.Material;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public class GemUnbinderListener
implements Listener {
    private final Map<UUID, Integer> unbindChanceMap = new HashMap<UUID, Integer>();

    @EventHandler
    public void onClick(InventoryClickEvent event) {
        String title = VersionedClass.invoke(event.getView(), "getTitle").toString();
        if (title.equals(Utils.colorTranslator("&cSelect a gem to unbind"))) {
            if (event.getClickedInventory() != null && event.getClickedInventory().getHolder() instanceof Player) {
                event.setCancelled(true);
                return;
            }
            Optional<SlimefunItem> gem = Optional.ofNullable(SlimefunItem.getByItem((ItemStack)event.getCurrentItem()));
            Player player = (Player)event.getWhoClicked();
            if (gem.isPresent() && gem.get() instanceof AbstractGem) {
                new GemUnbinderTask(player, player.getInventory().getItemInOffHand()).unbindGem(gem.get(), this.getUnbindChanceMap().get(player.getUniqueId()));
                event.getWhoClicked().closeInventory();
            }
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onRightClick(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Player player = event.getPlayer();
        SlimefunItem slimefunItem = SlimefunItem.getByItem((ItemStack)player.getInventory().getItemInMainHand());
        if (slimefunItem instanceof AbstractGemUnbinder) {
            event.setUseItemInHand(Event.Result.DENY);
            player.updateInventory();
            if (player.getInventory().getItemInOffHand().getType() == Material.AIR) {
                Utils.sendMessage("You have no item in your offhand that contain bounded gems!", (LivingEntity)player);
                return;
            }
            this.getUnbindChanceMap().put(player.getUniqueId(), ((AbstractGemUnbinder)slimefunItem).getChance());
            new GemUnbinderTask(player, player.getInventory().getItemInOffHand()).showAvailableGemsUI();
        }
    }

    public Map<UUID, Integer> getUnbindChanceMap() {
        return this.unbindChanceMap;
    }
}

