/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.machines;

import io.github.thebusybiscuit.slimefun4.api.MinecraftVersion;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockPlaceHandler;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import ne.fnfal113.fnamplifications.machines.abstracts.AbstractJukeBox;
import ne.fnfal113.fnamplifications.machines.implementation.DiscDurationsEnum;
import ne.fnfal113.fnamplifications.utils.Utils;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.block.Jukebox;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ElectricJukebox
extends AbstractJukeBox {
    private boolean newMusic = false;
    private final int lowerBound;
    private final int upperBound;
    private final int secondLowerBound;
    private final int secondUpperBound;
    private final boolean secondBound;
    private final Map<Location, Integer> durationMap = new HashMap<Location, Integer>();
    private final Map<Location, JukeboxCache> cacheMap = new HashMap<Location, JukeboxCache>();

    @ParametersAreNonnullByDefault
    public ElectricJukebox(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, int lowerBound, int upperBound, int secondLowerBound, int secondUpperBound, boolean hasSecondBound) {
        super(itemGroup, item, recipeType, recipe);
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.secondLowerBound = secondLowerBound;
        this.secondUpperBound = secondUpperBound;
        this.secondBound = hasSecondBound;
        this.addItemHandler(new ItemHandler[]{new BlockTicker(){

            public boolean isSynchronized() {
                return true;
            }

            public void tick(Block block, SlimefunItem slimefunItem, Config data) {
                ElectricJukebox.this.onTick(block);
            }
        }, new BlockPlaceHandler(false){

            public void onPlayerPlace(@Nonnull BlockPlaceEvent event) {
                BlockStorage.addBlockInfo((Block)event.getBlock(), (String)"owner", (String)event.getPlayer().getUniqueId().toString());
            }
        }, new BlockBreakHandler(false, false){

            public void onPlayerBreak(BlockBreakEvent e, ItemStack item, List<ItemStack> drops) {
                BlockMenu menu = BlockStorage.getInventory((Block)e.getBlock());
                if (menu != null) {
                    int upperBound = ElectricJukebox.this.isSecondBound() ? ElectricJukebox.this.getSecondUpperBound() : ElectricJukebox.this.getUpperBound();
                    for (int i = ElectricJukebox.this.getLowerBound(); i <= upperBound; ++i) {
                        if (menu.getItemInSlot(i) == null) continue;
                        ItemStack itemStack = menu.getItemInSlot(i);
                        ItemMeta meta = itemStack.getItemMeta();
                        if (meta.hasEnchant(Enchantment.BINDING_CURSE)) {
                            meta.removeEnchant(Enchantment.BINDING_CURSE);
                            itemStack.setItemMeta(meta);
                        }
                        if (itemStack.getType() == Material.PINK_STAINED_GLASS_PANE || itemStack.getType() == Material.GRAY_STAINED_GLASS_PANE) continue;
                        menu.dropItems(menu.getLocation(), new int[]{i});
                    }
                }
            }
        }});
        this.createPreset(this, this.getItemName(), blockMenuPreset -> {
            this.addGuiItems((BlockMenuPreset)blockMenuPreset);
            blockMenuPreset.addItem(5, (ItemStack)this.NO_POWER);
        });
    }

    public void addGuiItems(BlockMenuPreset menuPreset) {
        for (int i = 0; i < 54; ++i) {
            if (i < this.getLowerBound()) {
                menuPreset.addItem(i, ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
            }
            if (this.isSecondBound()) {
                if (i > this.getUpperBound() && i < this.getSecondLowerBound()) {
                    menuPreset.addItem(i, ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
                }
                if (i <= this.getSecondUpperBound()) continue;
                menuPreset.addItem(i, ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
                continue;
            }
            if (i <= this.getUpperBound()) continue;
            menuPreset.addItem(i, ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
        }
    }

    public boolean isJukeboxPowered(Block b, Player p) {
        if (this.getCharge(b.getLocation()) > 0) {
            return true;
        }
        Utils.sendMessage("Jukebox is not powered, needs power supply.", (LivingEntity)p);
        return false;
    }

    public void postRegister() {
        new BlockMenuPreset(this.getId(), this.getItemName()){

            public void init() {
                ElectricJukebox.this.addGuiItems(this);
            }

            public boolean canOpen(@Nonnull Block block, @Nonnull Player player) {
                return ElectricJukebox.this.canUse(player, false) && Slimefun.getProtectionManager().hasPermission((OfflinePlayer)player, block.getLocation(), Interaction.INTERACT_BLOCK);
            }

            public int[] getSlotsAccessedByItemTransport(ItemTransportFlow flow) {
                return new int[]{0};
            }

            public void newInstance(@Nonnull BlockMenu menu, @Nonnull Block b) {
                String isRunning = BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"toggled_On");
                String currentSlot = BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"current_Slot");
                String isPlaying = BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"is_Playing");
                boolean isOn = false;
                if (isRunning != null) {
                    isOn = Boolean.parseBoolean(isRunning);
                }
                menu.replaceExistingItem(50, (ItemStack)(isOn ? ElectricJukebox.this.TOGGLED_ON : ElectricJukebox.this.TOGGLED_OFF));
                menu.addMenuClickHandler(50, (p, slot, item, action) -> {
                    if (ElectricJukebox.this.isJukeboxPowered(b, p)) {
                        ElectricJukebox.this.toggleOnOrOff(menu);
                    }
                    return false;
                });
                int discSlot = ElectricJukebox.this.getLowerBound();
                if (currentSlot != null) {
                    discSlot = Integer.parseInt(currentSlot);
                }
                menu.replaceExistingItem(0, (ItemStack)ElectricJukebox.this.PREVIOUS);
                menu.addMenuClickHandler(0, (p, slot, item, action) -> {
                    if (ElectricJukebox.this.isJukeboxPowered(b, p)) {
                        ElectricJukebox.this.goToPreviousSlot(menu, p);
                    }
                    return false;
                });
                menu.replaceExistingItem(8, (ItemStack)ElectricJukebox.this.NEXT);
                menu.addMenuClickHandler(8, (p, slot, item, action) -> {
                    if (ElectricJukebox.this.isJukeboxPowered(b, p)) {
                        ElectricJukebox.this.goToNextSlot(menu, p);
                    }
                    return false;
                });
                boolean playing = false;
                if (isPlaying != null) {
                    playing = Boolean.parseBoolean(isPlaying);
                }
                menu.replaceExistingItem(4, (ItemStack)(playing ? ElectricJukebox.this.PLAY : ElectricJukebox.this.STOP));
                menu.addMenuClickHandler(4, (p, slot, item, action) -> {
                    if (ElectricJukebox.this.isJukeboxPowered(b, p)) {
                        ElectricJukebox.this.playOrStopJukebox(menu, p);
                    }
                    return false;
                });
                if (!ElectricJukebox.this.cacheMap.containsKey(menu.getLocation())) {
                    ElectricJukebox.this.cacheMap.put(menu.getLocation(), new JukeboxCache(isOn, playing, discSlot, null));
                }
            }
        };
    }

    public void onTick(@Nonnull Block b) {
        BlockMenu menu = BlockStorage.getInventory((Block)b);
        if (!(b.getBlockData() instanceof org.bukkit.block.data.type.Jukebox)) {
            return;
        }
        Jukebox jukebox = (Jukebox)menu.getBlock().getState();
        JukeboxCache cache = this.cacheMap.get(b.getLocation());
        if (this.getCharge(b.getLocation()) <= 0) {
            if (cache.isOn) {
                if (cache.isPlaying) {
                    this.unselectAndStopPlayingSlot(menu, jukebox);
                }
                menu.replaceExistingItem(48, ChestMenuUtils.getBackground());
                this.changeStatus(menu);
                this.toggleOnOrOff(menu);
            }
            return;
        }
        if (menu.hasViewer()) {
            menu.replaceExistingItem(48, (ItemStack)this.NOT_RUNNING);
        }
        if (cache.isOn) {
            if (cache.isPlaying) {
                int currentTime = this.durationMap.getOrDefault(b.getLocation(), 0);
                if (menu.hasViewer()) {
                    menu.replaceExistingItem(48, (ItemStack)this.OPERATING);
                    if (jukebox.getPlaying() != Material.AIR) {
                        menu.replaceExistingItem(49, (ItemStack)new CustomItemStack(Material.PINK_STAINED_GLASS_PANE, "&d&lPlaying: " + jukebox.getPlaying().toString().replace("_", " "), new String[]{"&eDuration : " + this.durationMap.get(b.getLocation()) + "/" + DiscDurationsEnum.valueOf(jukebox.getPlaying().toString().toUpperCase()).getDuration()}));
                    }
                }
                if (this.durationMap.containsKey(b.getLocation())) {
                    if (this.durationMap.get(b.getLocation()) >= DiscDurationsEnum.valueOf(jukebox.getPlaying().toString().toUpperCase()).getDuration()) {
                        this.goToNextSlot(menu, null);
                        currentTime = 0;
                    } else if (++currentTime == 1) {
                        jukebox.update(true);
                    }
                }
                this.durationMap.put(b.getLocation(), currentTime);
                Objects.requireNonNull(jukebox.getLocation().getWorld()).spawnParticle(Particle.NOTE, b.getLocation().add(0.0, 0.8, 0.0), 2);
            } else {
                this.durationMap.put(b.getLocation(), 0);
                if (menu.hasViewer()) {
                    menu.replaceExistingItem(48, (ItemStack)this.NOT_OPERATING);
                    this.changeStatus(menu);
                }
            }
            this.takeCharge(b.getLocation());
        } else if (cache.isPlaying) {
            this.unselectAndStopPlayingSlot(menu, jukebox);
            this.durationMap.put(b.getLocation(), 0);
            if (menu.hasViewer()) {
                this.changeStatus(menu);
            }
        }
    }

    @Override
    public void changeStatus(BlockMenu invMenu) {
        invMenu.replaceExistingItem(49, (ItemStack)new CustomItemStack(Material.MAGENTA_STAINED_GLASS_PANE, "&dNo music disc is being played", new String[]{"&ePlace a music disc then click", "&eplay button or left/right arrows"}));
    }

    @Override
    public void toggleOnOrOff(BlockMenu menu) {
        Location location = menu.getLocation();
        JukeboxCache cache = this.cacheMap.get(location);
        cache.isOn = !cache.isOn;
        this.cacheMap.put(location, cache);
        BlockStorage.addBlockInfo((Location)location, (String)"toggled_On", (String)String.valueOf(cache.isOn));
        menu.replaceExistingItem(50, (ItemStack)(cache.isOn ? this.TOGGLED_ON : this.TOGGLED_OFF));
    }

    @Override
    public void goToPreviousSlot(BlockMenu menu, @Nullable Player player) {
        Location location = menu.getLocation();
        JukeboxCache cache = this.cacheMap.get(location);
        Jukebox jukebox = (Jukebox)menu.getBlock().getState();
        if (!cache.isOn && player != null) {
            Utils.sendMessage("Jukebox is turned off, please turn it on", (LivingEntity)player);
            return;
        }
        this.validateSlotChange(menu, jukebox, -1);
    }

    @Override
    public void goToNextSlot(BlockMenu menu, @Nullable Player player) {
        Location location = menu.getLocation();
        JukeboxCache cache = this.cacheMap.get(location);
        Jukebox jukebox = (Jukebox)menu.getBlock().getState();
        if (!cache.isOn && player != null) {
            Utils.sendMessage("Jukebox is turned off, please turn it on", (LivingEntity)player);
            return;
        }
        this.validateSlotChange(menu, jukebox, 1);
    }

    @Override
    public void playOrStopJukebox(BlockMenu menu, Player player) {
        Location location = menu.getLocation();
        JukeboxCache cache = this.cacheMap.get(location);
        Jukebox jukebox = (Jukebox)menu.getBlock().getState();
        if (!cache.isOn) {
            Utils.sendMessage("Jukebox is turned off, please turn it on", (LivingEntity)player);
            return;
        }
        if (cache.isPlaying) {
            this.unselectAndStopPlayingSlot(menu, jukebox);
            return;
        }
        if (this.slotContainsMusicDisc(menu, 0)) {
            this.playSlot(menu, jukebox, 0);
            return;
        }
        Utils.sendMessage("Current slot has no music disc", (LivingEntity)player);
    }

    @Override
    public void playSlot(BlockMenu menu, Jukebox jukebox, int arithmetic) {
        JukeboxCache cache = this.cacheMap.get(menu.getLocation());
        cache.currentSlot += arithmetic;
        cache.isPlaying = true;
        cache.itemStack = menu.getItemInSlot(cache.currentSlot);
        menu.replaceExistingItem(4, (ItemStack)this.PLAY);
        BlockStorage.addBlockInfo((Location)menu.getLocation(), (String)"is_Playing", (String)String.valueOf(true));
        BlockStorage.addBlockInfo((Location)menu.getLocation(), (String)"current_Slot", (String)String.valueOf(cache.currentSlot));
        this.selectDisc(menu);
        jukebox.setPlaying(cache.itemStack.getType());
        jukebox.update(true);
        if (cache.isPlaying) {
            this.durationMap.put(menu.getLocation(), 0);
        }
        this.cacheMap.put(menu.getLocation(), cache);
    }

    @Override
    public void unselectAndStopPlayingSlot(BlockMenu menu, Jukebox jukebox) {
        JukeboxCache cache = this.cacheMap.get(menu.getLocation());
        this.unselectDisc(menu);
        cache.isPlaying = false;
        cache.itemStack = null;
        menu.replaceExistingItem(4, (ItemStack)this.STOP);
        BlockStorage.addBlockInfo((Location)menu.getLocation(), (String)"is_Playing", (String)String.valueOf(false));
        jukebox.setRecord(null);
        jukebox.update(true);
        this.cacheMap.put(menu.getLocation(), cache);
    }

    @Override
    public void validateSlotChange(BlockMenu menu, Jukebox jukebox, int arithmetic) {
        JukeboxCache cache = this.cacheMap.get(menu.getLocation());
        if (cache.currentSlot + arithmetic == this.getLowerBound() - 1) {
            return;
        }
        if (cache.itemStack != null && cache.isPlaying) {
            this.unselectAndStopPlayingSlot(menu, jukebox);
        } else {
            this.unselectCurrentSlot(menu);
        }
        if (this.isSecondBound()) {
            if (cache.currentSlot + arithmetic == this.getSecondUpperBound() + 1) {
                this.changeSlot(menu, jukebox, this.getLowerBound() - this.getSecondUpperBound());
                return;
            }
            if (cache.currentSlot + arithmetic < this.getSecondLowerBound() && cache.currentSlot + arithmetic > this.getUpperBound()) {
                this.changeSlot(menu, jukebox, arithmetic == 1 ? this.getSecondLowerBound() - this.getUpperBound() : this.getUpperBound() - this.getSecondLowerBound());
                return;
            }
        }
        if (cache.currentSlot + arithmetic == this.getUpperBound() + 1) {
            this.changeSlot(menu, jukebox, this.getLowerBound() - this.getUpperBound());
            return;
        }
        this.changeSlot(menu, jukebox, arithmetic);
    }

    @Override
    public void changeSlot(BlockMenu menu, Jukebox jukebox, int arithmetic) {
        JukeboxCache cache = this.cacheMap.get(menu.getLocation());
        if (this.slotContainsMusicDisc(menu, arithmetic)) {
            this.playSlot(menu, jukebox, arithmetic);
            return;
        }
        cache.currentSlot += arithmetic;
        BlockStorage.addBlockInfo((Location)menu.getLocation(), (String)"current_Slot", (String)String.valueOf(cache.currentSlot));
        menu.replaceExistingItem(cache.currentSlot, (ItemStack)new CustomItemStack(Material.PINK_STAINED_GLASS_PANE, "&eNo music disc in current slot", new String[]{"&eplease change the slot"}));
        menu.reload();
        this.cacheMap.put(menu.getLocation(), cache);
    }

    @Override
    public void unselectCurrentSlot(BlockMenu menu) {
        JukeboxCache cache = this.cacheMap.get(menu.getLocation());
        if (menu.getItemInSlot(cache.currentSlot) != null && menu.getItemInSlot(cache.currentSlot).getType() == Material.PINK_STAINED_GLASS_PANE) {
            menu.replaceExistingItem(cache.currentSlot, new ItemStack(Material.AIR));
            menu.reload();
        }
    }

    @Override
    public void selectDisc(BlockMenu menu) {
        ItemStack disc;
        JukeboxCache cache = this.cacheMap.get(menu.getLocation());
        ItemStack itemStack = disc = cache.itemStack != null ? cache.itemStack : menu.getItemInSlot(cache.currentSlot);
        if (disc == null) {
            return;
        }
        ItemMeta meta = disc.getItemMeta();
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        if (Slimefun.getMinecraftVersion().isAtLeast(MinecraftVersion.MINECRAFT_1_20_5)) {
            meta.setEnchantmentGlintOverride(Boolean.valueOf(true));
        }
        disc.setItemMeta(meta);
        menu.reload();
    }

    @Override
    public void unselectDisc(BlockMenu menu) {
        ItemStack disc;
        JukeboxCache cache = this.cacheMap.get(menu.getLocation());
        ItemStack itemStack = disc = cache.itemStack != null ? cache.itemStack : menu.getItemInSlot(cache.currentSlot);
        if (disc == null) {
            return;
        }
        ItemMeta meta = disc.getItemMeta();
        meta.removeEnchant(Enchantment.BINDING_CURSE);
        if (Slimefun.getMinecraftVersion().isAtLeast(MinecraftVersion.MINECRAFT_1_20_5)) {
            meta.setEnchantmentGlintOverride(Boolean.valueOf(false));
        }
        disc.setItemMeta(meta);
        menu.reload();
    }

    @Override
    public boolean slotContainsMusicDisc(BlockMenu menu, int arithmetic) {
        JukeboxCache cache = this.cacheMap.get(menu.getLocation());
        int slot = cache.currentSlot + arithmetic;
        return menu.getItemInSlot(slot) != null && menu.getItemInSlot(slot).getType() != Material.AIR && menu.getItemInSlot(slot).getType().name().startsWith("MUSIC_DISC");
    }

    public boolean isNewMusic() {
        return this.newMusic;
    }

    public void setNewMusic(boolean newMusic) {
        this.newMusic = newMusic;
    }

    public int getLowerBound() {
        return this.lowerBound;
    }

    public int getUpperBound() {
        return this.upperBound;
    }

    public int getSecondLowerBound() {
        return this.secondLowerBound;
    }

    public int getSecondUpperBound() {
        return this.secondUpperBound;
    }

    public boolean isSecondBound() {
        return this.secondBound;
    }

    public Map<Location, Integer> getDurationMap() {
        return this.durationMap;
    }

    public Map<Location, JukeboxCache> getCacheMap() {
        return this.cacheMap;
    }

    public static class JukeboxCache {
        public boolean isOn;
        public boolean isPlaying;
        public int currentSlot;
        public ItemStack itemStack;

        public JukeboxCache(boolean isOn, boolean isPlaying, int currentSlot, @Nullable ItemStack itemStack) {
            this.isOn = isOn;
            this.currentSlot = currentSlot;
            this.isPlaying = isPlaying;
            this.itemStack = itemStack;
        }
    }
}

