/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.gems;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import ne.fnfal113.fnamplifications.FNAmplifications;
import ne.fnfal113.fnamplifications.gems.abstracts.AbstractGem;
import ne.fnfal113.fnamplifications.gems.handlers.GemUpgrade;
import ne.fnfal113.fnamplifications.gems.handlers.OnDamageHandler;
import ne.fnfal113.fnamplifications.utils.Utils;
import ne.fnfal113.fnamplifications.utils.WeaponArmorEnum;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class ShockwaveGem
extends AbstractGem
implements OnDamageHandler,
GemUpgrade {
    private final List<Double> cosine = new ArrayList<Double>();
    private final List<Double> sine = new ArrayList<Double>();
    private final Map<UUID, Long> playerCooldownMap = new HashMap<UUID, Long>();

    public ShockwaveGem(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe, 15);
        for (int x = 0; x <= 360; ++x) {
            this.cosine.add(x, Math.cos(x));
            this.sine.add(x, Math.sin(x));
        }
    }

    @Override
    public void onDrag(Player player, SlimefunItem slimefunGemItem, ItemStack gemItem, ItemStack itemStackToSocket) {
        if (WeaponArmorEnum.HELMET.isTagged(itemStackToSocket.getType()) || WeaponArmorEnum.CHESTPLATE.isTagged(itemStackToSocket.getType()) || WeaponArmorEnum.LEGGINGS.isTagged(itemStackToSocket.getType()) || WeaponArmorEnum.BOOTS.isTagged(itemStackToSocket.getType())) {
            if (this.isUpgradeGem(gemItem, this.getId())) {
                this.upgradeGem(slimefunGemItem, itemStackToSocket, gemItem, player);
            } else {
                this.bindGem(slimefunGemItem, itemStackToSocket, player);
            }
        } else {
            Utils.sendMessage("Invalid item to socket! Gem works on armors only", (LivingEntity)player);
        }
    }

    @Override
    public void onDamage(EntityDamageByEntityEvent event, ItemStack itemStack) {
        if (event.isCancelled()) {
            return;
        }
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        if (!(event.getDamager() instanceof LivingEntity)) {
            return;
        }
        Player player = (Player)event.getEntity();
        LivingEntity livingEntity = (LivingEntity)event.getDamager();
        int tier = this.getTier(itemStack, this.getId());
        double amount = 3.5 * (double)(5 - tier);
        if (ThreadLocalRandom.current().nextInt(100) < this.getChance() / tier) {
            if (Utils.cooldownHelper(this.getPlayerCooldownMap().getOrDefault(player.getUniqueId(), 15L)) < 5L) {
                Long cd = Utils.cooldownHelper(this.getPlayerCooldownMap().get(player.getUniqueId()));
                Utils.sendMessage("Shockwave gem in cooldown for " + (5L - cd) + " seconds!", livingEntity);
                return;
            }
            this.getPlayerCooldownMap().put(player.getUniqueId(), System.currentTimeMillis());
            this.sendGemMessage(player, this.getItemName());
            player.getWorld().playSound(player.getLocation(), Sound.BLOCK_END_GATEWAY_SPAWN, 1.0f, 1.0f);
            livingEntity.damage(amount, (Entity)player);
            livingEntity.setVelocity(new Vector(0.0, 0.8, 0.0));
            for (Entity entity : livingEntity.getNearbyEntities(8.0, 8.0, 8.0)) {
                if (!(entity instanceof LivingEntity) || entity.getUniqueId().equals(player.getUniqueId())) continue;
                ((Damageable)entity).damage(amount, (Entity)player);
                entity.setVelocity(new Vector(0.0, 0.75, 0.0));
            }
            HashSet<Block> blocks = new HashSet<Block>();
            double height = 0.1;
            for (int i = 0; i < 8; ++i) {
                for (int c = 0; c <= 360; ++c) {
                    double x = (double)i * this.getCosine().get(c);
                    double z = (double)i * this.getSine().get(c);
                    Block block = player.getLocation().getBlock().getRelative((int)x, -1, (int)z);
                    if (blocks.contains(block) || block.getType() == Material.AIR || block.getRelative(BlockFace.UP).getType() != Material.AIR) continue;
                    blocks.add(block);
                    this.spawnJumpingBlock(block, height);
                    height += 0.003475;
                }
            }
        }
    }

    public void spawnJumpingBlock(Block blockOnGround, double height) {
        Location loc = blockOnGround.getRelative(BlockFace.UP).getLocation();
        FallingBlock block = blockOnGround.getWorld().spawnFallingBlock(loc, blockOnGround.getBlockData());
        block.setDropItem(false);
        block.setVelocity(new Vector(0.0, height, 0.0));
        block.setMetadata("shockwave_gem", (MetadataValue)new FixedMetadataValue((Plugin)FNAmplifications.getInstance(), (Object)"ghost_block"));
    }

    public List<Double> getCosine() {
        return this.cosine;
    }

    public List<Double> getSine() {
        return this.sine;
    }

    public Map<UUID, Long> getPlayerCooldownMap() {
        return this.playerCooldownMap;
    }
}

