/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.quivers.implementations;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import ne.fnfal113.fnamplifications.quivers.abstracts.AbstractQuiver;
import ne.fnfal113.fnamplifications.utils.Utils;
import ne.fnfal113.fnamplifications.utils.compatibility.VersionedEnchantmentPlus;
import org.bukkit.Material;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class QuiverTask {
    private final AbstractQuiver quiver;

    public QuiverTask(AbstractQuiver quiver) {
        this.quiver = quiver;
    }

    @Nullable
    public SlimefunItem getSfItem(ItemStack itemStack) {
        return SlimefunItem.getByItem((ItemStack)itemStack);
    }

    public int getArrows(ItemMeta meta) {
        return (Integer)meta.getPersistentDataContainer().getOrDefault(this.getQuiver().getStoredArrowsKey(), PersistentDataType.INTEGER, (Object)0);
    }

    public boolean isQuiver(@Nullable SlimefunItem sfItem) {
        return sfItem instanceof AbstractQuiver;
    }

    public void withdrawArrows(ItemStack quiverItemStack, ItemMeta meta, Player player) {
        int currentStoredArrowCount = this.getArrows(meta);
        if (currentStoredArrowCount <= 0) {
            return;
        }
        int newStoredArrowAcount = currentStoredArrowCount - 1;
        meta.getPersistentDataContainer().set(this.getQuiver().getStoredArrowsKey(), PersistentDataType.INTEGER, (Object)newStoredArrowAcount);
        if (newStoredArrowAcount == 0) {
            quiverItemStack.setType(Material.LEATHER);
            meta.getPersistentDataContainer().set(this.getQuiver().getStateKey(), PersistentDataType.STRING, (Object)"closed");
            Utils.sendMessage(this.getQuiver().getItemName() + " has been emptied! No more arrows stored", (LivingEntity)player);
            Utils.setLoreByPdc(quiverItemStack, meta, "Closed (empty)", "State: ", "&e", "&f", "");
        }
        Utils.setLoreByPdc(quiverItemStack, meta, String.valueOf(newStoredArrowAcount), "Arrows: ", "&e", "&f", " left");
        player.getInventory().addItem(new ItemStack[]{this.getQuiver().getArrowType().clone()});
    }

    public void depositArrows(ItemStack quiverItemStack, ItemMeta meta, Player player) {
        ItemStack arrowItemStack = player.getInventory().getItemInMainHand();
        PersistentDataContainer quiverPdc = meta.getPersistentDataContainer();
        int currentStoredArrowCount = this.getArrows(meta);
        if (arrowItemStack.getType() != this.getQuiver().getArrowType().getType()) {
            return;
        }
        if (this.isQuiver(this.getSfItem(arrowItemStack))) {
            return;
        }
        if (quiverItemStack.getAmount() != 1) {
            Utils.sendMessage("Cannot use quiver! Unstack the quivers first before using", (LivingEntity)player);
            return;
        }
        int newStoredArrowCount = currentStoredArrowCount + 1;
        if (newStoredArrowCount <= this.getQuiver().getQuiverSize()) {
            quiverPdc.set(this.getQuiver().getStoredArrowsKey(), PersistentDataType.INTEGER, (Object)newStoredArrowCount);
            if (!quiverPdc.has(this.getQuiver().getRandomIdKey(), PersistentDataType.INTEGER)) {
                int random = ThreadLocalRandom.current().nextInt(1, 1000000);
                quiverPdc.set(this.getQuiver().getRandomIdKey(), PersistentDataType.INTEGER, (Object)random);
            }
            arrowItemStack.setAmount(arrowItemStack.getAmount() - 1);
            Utils.setLoreByPdc(quiverItemStack, meta, String.valueOf(newStoredArrowCount), "Arrows: ", "&e", "&f", " left");
            Utils.setLoreByPdc(quiverItemStack, meta, "Open", "State: ", "&e", "&f", "");
        } else {
            Utils.sendMessage(this.getQuiver().getItemName() + " is full! Cannot deposit arrows", (LivingEntity)player);
        }
    }

    public void bowShoot(PlayerInteractEvent event, ItemStack quiverItemStack, Material itemInMainHandType) {
        int newStoredArrowCount;
        ItemMeta bowMeta;
        Player player = event.getPlayer();
        ItemMeta meta = quiverItemStack.getItemMeta();
        ItemMeta itemMeta = bowMeta = itemInMainHandType == Material.BOW || itemInMainHandType == Material.CROSSBOW ? player.getInventory().getItemInMainHand().getItemMeta() : player.getInventory().getItemInOffHand().getItemMeta();
        if (meta == null || bowMeta == null) {
            return;
        }
        PersistentDataContainer quiverPdc = meta.getPersistentDataContainer();
        boolean hasInfinity = bowMeta.hasEnchant(VersionedEnchantmentPlus.INFINITY);
        int currentStoredArrowCount = this.getArrows(meta);
        int n = newStoredArrowCount = this.quiver.getArrowType().getType() == Material.ARROW && hasInfinity ? currentStoredArrowCount : currentStoredArrowCount - 1;
        if (this.quiver.getArrowType().getType() == Material.ARROW && !hasInfinity) {
            player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.ARROW)});
        } else if (this.quiver.getArrowType().getType() == Material.SPECTRAL_ARROW && !hasInfinity) {
            player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.SPECTRAL_ARROW)});
        }
        if (newStoredArrowCount >= 0) {
            quiverPdc.set(this.getQuiver().getStoredArrowsKey(), PersistentDataType.INTEGER, (Object)newStoredArrowCount);
            Utils.setLoreByPdc(quiverItemStack, meta, String.valueOf(newStoredArrowCount), "Arrows: ", "&e", "&f", " left");
            if (newStoredArrowCount == 0) {
                meta.getPersistentDataContainer().set(this.getQuiver().getStateKey(), PersistentDataType.STRING, (Object)"closed");
                Utils.sendMessage(this.getQuiver().getItemName() + " has been emptied! No more arrows stored", (LivingEntity)player);
                Utils.setLoreByPdc(quiverItemStack, meta, "Closed (empty)", "State: ", "&e", "&f", "");
            }
        }
    }

    public AbstractQuiver getQuiver() {
        return this.quiver;
    }
}

