/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.gems;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import ne.fnfal113.fnamplifications.FNAmplifications;
import ne.fnfal113.fnamplifications.gems.abstracts.AbstractGem;
import ne.fnfal113.fnamplifications.gems.handlers.GemUpgrade;
import ne.fnfal113.fnamplifications.gems.handlers.OnDamageHandler;
import ne.fnfal113.fnamplifications.utils.Utils;
import ne.fnfal113.fnamplifications.utils.WeaponArmorEnum;
import org.bukkit.Bukkit;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class LifestealGem
extends AbstractGem
implements OnDamageHandler,
GemUpgrade {
    public LifestealGem(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe, 12);
    }

    @Override
    public void onDrag(Player player, SlimefunItem slimefunGemItem, ItemStack gemItem, ItemStack itemStackToSocket) {
        if (WeaponArmorEnum.SWORDS.isTagged(itemStackToSocket.getType()) || WeaponArmorEnum.AXES.isTagged(itemStackToSocket.getType())) {
            if (this.isUpgradeGem(gemItem, this.getId())) {
                this.upgradeGem(slimefunGemItem, itemStackToSocket, gemItem, player);
            } else {
                this.bindGem(slimefunGemItem, itemStackToSocket, player);
            }
        } else {
            Utils.sendMessage("Invalid item to socket! Gem works on swords and axes only", (LivingEntity)player);
        }
    }

    @Override
    public void onDamage(EntityDamageByEntityEvent event, ItemStack itemStack) {
        if (event.isCancelled()) {
            return;
        }
        if (!(event.getEntity() instanceof LivingEntity)) {
            return;
        }
        if (!(event.getDamager() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getDamager();
        LivingEntity livingEntity = (LivingEntity)event.getEntity();
        if (ThreadLocalRandom.current().nextInt(100) < this.getChance() / this.getTier(itemStack, this.getId())) {
            Bukkit.getScheduler().runTaskLater((Plugin)FNAmplifications.getInstance(), () -> {
                int playerDefaultHealth = (int)Objects.requireNonNull(player.getAttribute(Attribute.GENERIC_MAX_HEALTH)).getValue();
                if (player.getHealth() <= (double)(playerDefaultHealth - 2) && livingEntity.getHealth() > 2.0 && !livingEntity.isDead()) {
                    player.setHealth(player.getHealth() + 2.0);
                    livingEntity.setHealth(livingEntity.getHealth() - 2.0);
                    this.sendGemMessage(player, this.getItemName());
                }
            }, 3L);
        }
    }
}

