/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.gems;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import ne.fnfal113.fnamplifications.FNAmplifications;
import ne.fnfal113.fnamplifications.gems.abstracts.AbstractGem;
import ne.fnfal113.fnamplifications.gems.handlers.OnRightClickHandler;
import ne.fnfal113.fnamplifications.gems.implementation.ThrowWeaponTask;
import ne.fnfal113.fnamplifications.utils.Keys;
import ne.fnfal113.fnamplifications.utils.Utils;
import ne.fnfal113.fnamplifications.utils.WeaponArmorEnum;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class AxeThrowieGem
extends AbstractGem
implements OnRightClickHandler {
    public AxeThrowieGem(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
    }

    @Override
    public void onDrag(Player player, SlimefunItem slimefunGemItem, ItemStack gemItem, ItemStack itemStackToSocket) {
        if (WeaponArmorEnum.AXES.isTagged(itemStackToSocket.getType())) {
            this.bindGem(slimefunGemItem, itemStackToSocket, player);
        } else {
            Utils.sendMessage("Invalid item to socket! Gem works on axes only", (LivingEntity)player);
        }
    }

    @Override
    public void onRightClick(Player player) {
        if (player.isSneaking()) {
            return;
        }
        if (!this.hasPermissionToThrow(player)) {
            Utils.sendMessage("You don't have the permission to throw here! (Needs block interaction flag enabled)", (LivingEntity)player);
            return;
        }
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        ItemMeta meta = itemStack.getItemMeta();
        PersistentDataContainer pdc = itemStack.getItemMeta().getPersistentDataContainer();
        try {
            String pdcValue = (String)pdc.getOrDefault(Keys.RETURN_WEAPON_KEY, PersistentDataType.STRING, (Object)"false");
            Vector vector = player.getLocation().add(player.getLocation().getDirection().multiply(9).normalize()).subtract(player.getLocation().toVector()).toVector();
            ThrowWeaponTask throwWeaponTask = new ThrowWeaponTask(player, itemStack.clone(), true, false, pdcValue.equalsIgnoreCase("true"), vector);
            throwWeaponTask.runTaskTimer((Plugin)FNAmplifications.getInstance(), 0L, 1L);
        }
        catch (IllegalArgumentException e) {
            pdc.set(Keys.RETURN_WEAPON_KEY, PersistentDataType.STRING, (Object)"true");
            itemStack.setItemMeta(meta);
            return;
        }
        itemStack.setAmount(0);
    }
}

