/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.gems;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.utils.compatibility.VersionedParticle;
import java.util.concurrent.ThreadLocalRandom;
import ne.fnfal113.fnamplifications.FNAmplifications;
import ne.fnfal113.fnamplifications.gems.abstracts.AbstractGem;
import ne.fnfal113.fnamplifications.gems.handlers.GemUpgrade;
import ne.fnfal113.fnamplifications.gems.handlers.OnPlayerDeathHandler;
import ne.fnfal113.fnamplifications.utils.Utils;
import ne.fnfal113.fnamplifications.utils.WeaponArmorEnum;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class AwakenGem
extends AbstractGem
implements OnPlayerDeathHandler,
GemUpgrade {
    public AwakenGem(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe, 15);
    }

    @Override
    public void onDrag(Player player, SlimefunItem slimefunGemItem, ItemStack gemItem, ItemStack itemStackToSocket) {
        if (WeaponArmorEnum.HELMET.isTagged(itemStackToSocket.getType())) {
            if (this.isUpgradeGem(gemItem, this.getId())) {
                this.upgradeGem(slimefunGemItem, itemStackToSocket, gemItem, player);
            } else {
                this.bindGem(slimefunGemItem, itemStackToSocket, player);
            }
        } else {
            Utils.sendMessage("Invalid item to socket! Gem works on helmet only", (LivingEntity)player);
        }
    }

    @Override
    public void onPlayerDeath(PlayerDeathEvent event, ItemStack itemStack) {
        if (ThreadLocalRandom.current().nextInt(100) < this.getChance() / this.getTier(itemStack, this.getId())) {
            Player player = event.getEntity();
            Location loc = player.getLocation();
            Bukkit.getScheduler().runTaskLater((Plugin)FNAmplifications.getInstance(), () -> {
                player.spigot().respawn();
                player.teleport(loc.clone());
                player.playSound(loc, Sound.ENTITY_VINDICATOR_CELEBRATE, 1.0f, 1.0f);
                this.sendGemMessage(player, this.getItemName());
                for (int d = 0; d <= 90; ++d) {
                    int r = ThreadLocalRandom.current().nextInt(255);
                    int g = ThreadLocalRandom.current().nextInt(255);
                    int b = ThreadLocalRandom.current().nextInt(255);
                    Location particleLoc = new Location(loc.getWorld(), loc.getX(), loc.getY(), loc.getZ());
                    particleLoc.setX(loc.getX() + Math.cos(d) * 2.0);
                    particleLoc.setZ(loc.getZ() + Math.sin(d) * 2.0);
                    player.getWorld().spawnParticle(VersionedParticle.DUST, particleLoc, 2, (Object)new Particle.DustOptions(Color.fromRGB((int)r, (int)g, (int)b), 2.0f));
                }
            }, 2L);
            event.setKeepInventory(true);
            event.getDrops().clear();
        }
    }
}

