/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.mysteriousitems;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.utils.compatibility.VersionedEnchantment;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import ne.fnfal113.fnamplifications.mysteriousitems.abstracts.AbstractStick;
import ne.fnfal113.fnamplifications.utils.Keys;
import ne.fnfal113.fnamplifications.utils.Utils;
import ne.fnfal113.fnamplifications.utils.compatibility.VersionedEnchantmentPlus;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;

public class MysteryStick5
extends AbstractStick {
    private final Material material;

    @ParametersAreNonnullByDefault
    public MysteryStick5(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, Material material) {
        super(itemGroup, item, recipeType, recipe, Keys.STICK_5_EXP_LEVELS, Keys.STICK_5_DAMAGE, 2, 15);
        this.material = material;
    }

    @Override
    public Map<Enchantment, Integer> enchantments() {
        HashMap<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();
        enchantments.put(VersionedEnchantmentPlus.BANE_OF_ARTHROPODS, 4);
        enchantments.put(VersionedEnchantment.SHARPNESS, 3);
        enchantments.put(VersionedEnchantmentPlus.SMITE, 4);
        return enchantments;
    }

    @Override
    public String weaponLore() {
        return ChatColor.GOLD + "Another stick of somewhat reckoning";
    }

    @Override
    public String stickLore() {
        return ChatColor.WHITE + "I know you are tired of this stick thing";
    }

    @Override
    public Material getStickMaterial() {
        return this.getMaterial();
    }

    @Override
    public void onSwing(EntityDamageByEntityEvent event) {
        if (!(event.getDamager() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getDamager();
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item.getType() != this.getMaterial()) {
            return;
        }
        if (this.getStickTask().onSwing(item, player, event.getDamage(), 24, 2)) {
            LivingEntity victim = (LivingEntity)event.getEntity();
            victim.addPotionEffect(new PotionEffect(this.getRandomPotionEffectType(), 100, 1, false, false, false));
            victim.addPotionEffect(new PotionEffect(this.getRandomPotionEffectType(), 40, 0, false, false, false));
            Utils.sendMessage("Mystery effects was applied to your enemy", (LivingEntity)player);
        }
    }

    public Material getMaterial() {
        return this.material;
    }
}

