/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.quivers.implementations;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import ne.fnfal113.fnamplifications.quivers.abstracts.AbstractQuiver;
import ne.fnfal113.fnamplifications.utils.Utils;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Player;
import org.bukkit.entity.SpectralArrow;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class QuiverTask {
    private final AbstractQuiver quiver;

    public QuiverTask(AbstractQuiver quiver) {
        this.quiver = quiver;
    }

    @Nullable
    public SlimefunItem getSfItem(ItemStack itemStack) {
        return SlimefunItem.getByItem((ItemStack)itemStack);
    }

    public int getArrows(PersistentDataContainer quiverPdc, NamespacedKey key) {
        return (Integer)quiverPdc.getOrDefault(key, PersistentDataType.INTEGER, (Object)0);
    }

    public boolean isQuiver(@Nullable SlimefunItem sfItem) {
        return sfItem instanceof AbstractQuiver;
    }

    public void changeState(ItemStack quiverItemStack, ItemMeta meta) {
        PersistentDataContainer quiverPdc = meta.getPersistentDataContainer();
        int arrowCount = this.getArrows(quiverPdc, this.getQuiver().getStoredArrowsKey());
        if (arrowCount <= 0) {
            return;
        }
        if (quiverItemStack.getType() == Material.LEATHER) {
            meta.getPersistentDataContainer().set(this.getQuiver().getStateKey(), PersistentDataType.STRING, (Object)"opened");
            quiverItemStack.setType(this.getQuiver().getArrowType().getType());
            Utils.setLoreByPdc(quiverItemStack, meta, "Open", "State: ", "&e", "&f", "");
        } else {
            meta.getPersistentDataContainer().set(this.getQuiver().getStateKey(), PersistentDataType.STRING, (Object)"closed");
            quiverItemStack.setType(Material.LEATHER);
            Utils.setLoreByPdc(quiverItemStack, meta, "Closed", "State: ", "&e", "&f", "");
        }
    }

    public void withdrawArrows(ItemStack quiverItemStack, ItemMeta meta, Player player) {
        PersistentDataContainer quiverPdc = meta.getPersistentDataContainer();
        int currentStoredArrowCount = this.getArrows(quiverPdc, this.getQuiver().getStoredArrowsKey());
        if (currentStoredArrowCount <= 0) {
            return;
        }
        int newStoredArrowAcount = currentStoredArrowCount - 1;
        meta.getPersistentDataContainer().set(this.getQuiver().getStoredArrowsKey(), PersistentDataType.INTEGER, (Object)newStoredArrowAcount);
        if (newStoredArrowAcount == 0) {
            quiverItemStack.setType(Material.LEATHER);
            meta.getPersistentDataContainer().set(this.getQuiver().getStateKey(), PersistentDataType.STRING, (Object)"closed");
            player.sendMessage(ChatColor.GOLD + this.getQuiver().getItemName() + " has been emptied! No more arrows stored");
            Utils.setLoreByPdc(quiverItemStack, meta, "Closed (empty)", "State: ", "&e", "&f", "");
        }
        Utils.setLoreByPdc(quiverItemStack, meta, String.valueOf(newStoredArrowAcount), "Arrows: ", "&e", "&f", " left");
        player.getInventory().addItem(new ItemStack[]{this.getQuiver().getArrowType().clone()});
    }

    public void depositArrows(ItemStack quiverItemStack, ItemMeta meta, Player player) {
        ItemStack arrowItemStack = player.getInventory().getItemInMainHand();
        PersistentDataContainer quiverPdc = meta.getPersistentDataContainer();
        int currentStoredArrowCount = this.getArrows(quiverPdc, this.getQuiver().getStoredArrowsKey());
        if (arrowItemStack.getType() != this.getQuiver().getArrowType().getType()) {
            return;
        }
        if (this.isQuiver(this.getSfItem(arrowItemStack))) {
            return;
        }
        if (quiverItemStack.getAmount() != 1) {
            player.sendMessage(Utils.colorTranslator("&eCannot use quiver! Unstack the quivers first before using"));
            return;
        }
        int newStoredArrowCount = currentStoredArrowCount + 1;
        if (newStoredArrowCount <= this.getQuiver().getQuiverSize()) {
            quiverPdc.set(this.getQuiver().getStoredArrowsKey(), PersistentDataType.INTEGER, (Object)newStoredArrowCount);
            if (!quiverPdc.has(this.getQuiver().getRandomIdKey(), PersistentDataType.INTEGER)) {
                int random = ThreadLocalRandom.current().nextInt(1, 1000000);
                quiverPdc.set(this.getQuiver().getRandomIdKey(), PersistentDataType.INTEGER, (Object)random);
            }
            quiverItemStack.setType(this.getQuiver().getArrowType().getType());
            arrowItemStack.setAmount(arrowItemStack.getAmount() - 1);
            Utils.setLoreByPdc(quiverItemStack, meta, String.valueOf(newStoredArrowCount), "Arrows: ", "&e", "&f", " left");
            Utils.setLoreByPdc(quiverItemStack, meta, "Open", "State: ", "&e", "&f", "");
        } else {
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(this.getQuiver().getItemName() + " is full! Cannot deposit arrows")));
        }
    }

    public void bowShoot(EntityShootBowEvent event, ItemStack quiverItemStack, boolean isNormalArrow) {
        int newStoredArrowCount;
        Player player = (Player)event.getEntity();
        event.setCancelled(true);
        float bowForce = event.getForce();
        if (quiverItemStack.getType() == Material.ARROW) {
            Arrow arrow = (Arrow)player.launchProjectile(Arrow.class);
            arrow.setVelocity(arrow.getVelocity().multiply(bowForce));
        } else if (quiverItemStack.getType() == Material.SPECTRAL_ARROW) {
            SpectralArrow spectralArrow = (SpectralArrow)player.launchProjectile(SpectralArrow.class);
            spectralArrow.setVelocity(spectralArrow.getVelocity().multiply(bowForce));
        }
        player.getWorld().playSound(player.getLocation(), Sound.ENTITY_ARROW_SHOOT, 1.0f, 1.0f);
        player.updateInventory();
        ItemMeta meta = quiverItemStack.getItemMeta();
        ItemMeta bowMeta = player.getInventory().getItemInMainHand().getItemMeta();
        if (meta == null || bowMeta == null) {
            return;
        }
        PersistentDataContainer quiverPdc = meta.getPersistentDataContainer();
        int currentStoredArrowCount = this.getArrows(quiverPdc, this.getQuiver().getStoredArrowsKey());
        int n = newStoredArrowCount = isNormalArrow && bowMeta.hasEnchant(Enchantment.ARROW_INFINITE) ? currentStoredArrowCount : currentStoredArrowCount - 1;
        if (newStoredArrowCount >= 0) {
            quiverPdc.set(this.getQuiver().getStoredArrowsKey(), PersistentDataType.INTEGER, (Object)newStoredArrowCount);
            Utils.setLoreByPdc(quiverItemStack, meta, String.valueOf(newStoredArrowCount), "Arrows: ", "&e", "&f", " left");
            if (newStoredArrowCount == 0) {
                quiverItemStack.setType(Material.LEATHER);
                meta.getPersistentDataContainer().set(this.getQuiver().getStateKey(), PersistentDataType.STRING, (Object)"closed");
                player.sendMessage(ChatColor.GOLD + this.getQuiver().getItemName() + " has been emptied! No more arrows stored");
                Utils.setLoreByPdc(quiverItemStack, meta, "Closed (empty)", "State: ", "&e", "&f", "");
            }
        }
    }

    public AbstractQuiver getQuiver() {
        return this.quiver;
    }
}

