/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.gems.implementation;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import java.util.List;
import ne.fnfal113.fnamplifications.gems.implementation.Gem;
import ne.fnfal113.fnamplifications.utils.Keys;
import ne.fnfal113.fnamplifications.utils.Utils;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class UpgradedGem
extends Gem {
    private final NamespacedKey key;

    public UpgradedGem(SlimefunItem slimefunGemItem, ItemStack itemStackToSocket, Player p) {
        super(slimefunGemItem, itemStackToSocket, p);
        this.key = Keys.createKey(slimefunGemItem.getId().toLowerCase() + "_gem_tier");
    }

    public void upgradeExistingGem(ItemStack slimefunGemItem, int gemTier) {
        ItemMeta meta = this.getItemStackToSocket().getItemMeta();
        PersistentDataContainer container = meta.getPersistentDataContainer();
        int currentGemTier = (Integer)container.getOrDefault(this.getKey(), PersistentDataType.INTEGER, (Object)4);
        List lore = meta.getLore();
        if (this.isSameGem(this.getItemStackToSocket())) {
            if (currentGemTier - 1 == gemTier) {
                this.getPlayer().setItemOnCursor(new ItemStack(Material.AIR));
                if (lore != null) {
                    for (int i = 0; i < lore.size(); ++i) {
                        if (!((String)lore.get(i)).contains(Utils.colorTranslator(this.getSlimefunGemItem().getItemName().substring(0, this.getSlimefunGemItem().getItemName().lastIndexOf(" ") + 2)))) continue;
                        lore.set(i, ChatColor.RED + "\u25ec " + slimefunGemItem.getItemMeta().getDisplayName());
                    }
                    meta.setLore(lore);
                    meta.getPersistentDataContainer().set(this.key, PersistentDataType.INTEGER, (Object)gemTier);
                    this.getItemStackToSocket().setItemMeta(meta);
                    this.getPlayer().playSound(this.getPlayer().getLocation(), Sound.ENTITY_DRAGON_FIREBALL_EXPLODE, 1.0f, 1.0f);
                }
            } else {
                this.getPlayer().playSound(this.getPlayer().getLocation(), Sound.BLOCK_NOTE_BLOCK_BIT, 1.0f, 1.0f);
                this.getPlayer().sendMessage(Utils.colorTranslator("&eGem tier not compatible! upgrades must be in order (1-2-3-4)!"));
            }
        } else {
            this.getPlayer().sendMessage(Utils.colorTranslator("&eYou do not have a similar gem that can be upgraded!"));
        }
    }

    public NamespacedKey getKey() {
        return this.key;
    }
}

