/*
 * Decompiled with CFR 0.152.
 */
package ne.fnfal113.fnamplifications.gems;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import java.util.concurrent.ThreadLocalRandom;
import ne.fnfal113.fnamplifications.gems.abstracts.AbstractGem;
import ne.fnfal113.fnamplifications.gems.handlers.GemUpgrade;
import ne.fnfal113.fnamplifications.gems.handlers.OnPlayerDeathHandler;
import ne.fnfal113.fnamplifications.utils.Utils;
import ne.fnfal113.fnamplifications.utils.WeaponArmorEnum;
import org.bukkit.Location;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.inventory.ItemStack;

public class AvengeGem
extends AbstractGem
implements OnPlayerDeathHandler,
GemUpgrade {
    public AvengeGem(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe, 13);
    }

    @Override
    public void onDrag(Player player, SlimefunItem slimefunGemItem, ItemStack gemItem, ItemStack itemStackToSocket) {
        if (WeaponArmorEnum.BOOTS.isTagged(itemStackToSocket.getType())) {
            if (this.isUpgradeGem(gemItem, this.getId())) {
                this.upgradeGem(slimefunGemItem, itemStackToSocket, gemItem, player);
            } else {
                this.bindGem(slimefunGemItem, itemStackToSocket, player);
            }
        } else {
            player.sendMessage(Utils.colorTranslator("&eInvalid item to socket! Gem works on boots only"));
        }
    }

    @Override
    public void onPlayerDeath(PlayerDeathEvent event, ItemStack itemStack) {
        if (ThreadLocalRandom.current().nextInt(100) < this.getChance() / this.getTier(itemStack, this.getId())) {
            Player player = event.getEntity();
            Location loc = player.getLocation();
            Creeper creeper = (Creeper)player.getWorld().spawn(loc.clone(), Creeper.class);
            creeper.setPowered(true);
            creeper.setExplosionRadius(4);
            this.sendGemMessage(event.getEntity(), this.getItemName());
        }
    }
}

