/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.extraheads.listeners;

import io.github.thebusybiscuit.extraheads.ExtraHeads;
import io.github.thebusybiscuit.extraheads.libs.annotation.Nonnull;
import io.github.thebusybiscuit.extraheads.libs.annotation.Nullable;
import io.github.thebusybiscuit.extraheads.setup.Registry;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.implementation.items.weapons.SwordOfBeheading;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class HeadListener
implements Listener {
    private final ExtraHeads plugin;

    public HeadListener(ExtraHeads plugin) {
        this.plugin = plugin;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler(ignoreCancelled=true)
    public void onKill(EntityDeathEvent e) {
        Registry registry = ExtraHeads.getRegistry();
        EntityType entityType = e.getEntityType();
        double chance = this.getChance(entityType, e.getEntity().getKiller());
        if ((double)ThreadLocalRandom.current().nextInt(100) < chance) {
            e.getEntity().getWorld().dropItemNaturally(e.getEntity().getLocation(), registry.getHeads().get(entityType).getItem().clone());
        }
    }

    private double getChance(@Nonnull EntityType type, @Nullable Player killer) {
        if (!ExtraHeads.getRegistry().getHeads().containsKey(type)) {
            return 0.0;
        }
        double chance = ExtraHeads.getRegistry().getConfig().getDouble("chances." + String.valueOf(type));
        if (killer == null) {
            return chance;
        }
        ItemStack item = killer.getInventory().getItemInMainHand();
        SwordOfBeheading sword = (SwordOfBeheading)SlimefunItems.SWORD_OF_BEHEADING.getItem();
        if (item.isEmpty() || sword == null || !sword.isItem(item) || sword.isDisabledIn(killer.getWorld())) {
            return chance;
        }
        return chance * ExtraHeads.getRegistry().getConfig().getDouble("options.sword-of-beheading-multiplier");
    }
}

