/*
 * Decompiled with CFR 0.152.
 */
package me.vaan.customitemgen.file;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.vaan.customitemgen.CustomItemGenerators;
import me.vaan.customitemgen.generator.GenEntry;
import me.vaan.customitemgen.generator.ItemGenerator;
import me.vaan.customitemgen.util.ConfigFunctionsKt;
import me.vaan.customitemgen.util.StringFunctionsKt;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lme/vaan/customitemgen/file/MachineLoader;", "", "<init>", "()V", "loadFiles", "", "file", "Ljava/io/File;", "CustomItemGenerators"})
@SourceDebugExtension(value={"SMAP\nMachineLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MachineLoader.kt\nme/vaan/customitemgen/file/MachineLoader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,50:1\n1#2:51\n*E\n"})
public final class MachineLoader {
    @NotNull
    public static final MachineLoader INSTANCE = new MachineLoader();

    private MachineLoader() {
    }

    public final void loadFiles(@NotNull File file) {
        Intrinsics.checkNotNullParameter(file, "file");
        YamlConfiguration machines = new YamlConfiguration();
        machines.load(file);
        for (String id : machines.getKeys(false)) {
            Material progressBarMaterial;
            RecipeType recipeType;
            String recipeTypeString;
            String progressBarString;
            if (!machines.getBoolean(id + ".enabled")) continue;
            ItemStack stack = ConfigFunctionsKt.getStack((FileConfiguration)machines, id + ".item");
            SlimefunItemStack machineItem = new SlimefunItemStack(id, stack);
            int energyCapacity = machines.getInt(id + ".energy-capacity");
            if (machines.getString(id + ".progress-bar") == null) {
                throw new RuntimeException(id + " machine progress entry not found");
            }
            if (Material.getMaterial((String)progressBarString) == null) {
                throw new RuntimeException(id + " machine progress bar material not found");
            }
            if (machines.getString(id + ".recipe.type") == null) {
                throw new RuntimeException(id + " machine recipe type not specified");
            }
            if (StringFunctionsKt.getRecipeType(recipeTypeString) == null) {
                throw new RuntimeException(id + " machine recipe type not found");
            }
            FileConfiguration fileConfiguration = (FileConfiguration)machines;
            Intrinsics.checkNotNull(id);
            ItemStack[] recipe = ConfigFunctionsKt.getRecipe(fileConfiguration, id);
            if (recipe.length == 0) {
                throw new RuntimeException(id + " has invalid/empty recipe");
            }
            List<GenEntry> production = ConfigFunctionsKt.getProduction((FileConfiguration)machines, id);
            if (production.isEmpty()) {
                throw new RuntimeException(id + " has invalid/empty production list");
            }
            Iterator iterator2 = ((Iterable)production).iterator();
            if (!iterator2.hasNext()) {
                throw new NoSuchElementException();
            }
            GenEntry it = (GenEntry)iterator2.next();
            boolean bl = false;
            int n = it.getEnergy();
            while (iterator2.hasNext()) {
                GenEntry it2 = (GenEntry)iterator2.next();
                $i$a$-maxOf-MachineLoader$loadFiles$maxProduction$1 = false;
                int n2 = it2.getEnergy();
                if (n >= n2) continue;
                n = n2;
            }
            int maxProduction = n;
            if (energyCapacity < maxProduction) {
                throw new RuntimeException(id + " the energy-capacity must always be above the energy production cost");
            }
            new ItemGenerator(CustomItemGenerators.Companion.getGroup(), machineItem, recipeType, recipe, new ItemStack(progressBarMaterial), production).setCapacity(energyCapacity).register(CustomItemGenerators.Companion.getInstance());
        }
    }
}

