/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.displaymodellib.sefilib.slimefun.items;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.implementation.items.LimitedUseItem;
import io.github.thebusybiscuit.slimefun4.libraries.dough.common.ChatColors;
import io.github.thebusybiscuit.slimefun4.utils.LoreBuilder;
import io.github.thebusybiscuit.slimefun4.utils.PatternUtils;
import java.util.Collections;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public abstract class RefillableUseItem
extends LimitedUseItem {
    protected RefillableUseItem(ItemGroup group, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(group, item, recipeType, recipe);
    }

    protected void refillItem(ItemStack itemStack) {
        this.refillItem(itemStack, 1);
    }

    @ParametersAreNonnullByDefault
    protected void refillItem(ItemStack itemStack, int refillAmount) {
        ItemMeta meta = itemStack.getItemMeta();
        NamespacedKey key = this.getStorageKey();
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        int usesLeft = (Integer)pdc.getOrDefault(key, PersistentDataType.INTEGER, (Object)this.getMaxUseCount());
        usesLeft = Math.min(usesLeft + refillAmount, this.getMaxUseCount());
        pdc.set(key, PersistentDataType.INTEGER, (Object)usesLeft);
        this.updateLore(itemStack, meta, usesLeft);
    }

    @ParametersAreNonnullByDefault
    protected void updateLore(ItemStack itemStack, ItemMeta itemMeta, int usesLeft) {
        List lore = itemMeta.getLore();
        String newLine = ChatColors.color((String)LoreBuilder.usesLeft((int)usesLeft));
        if (lore != null && !lore.isEmpty()) {
            for (int i = 0; i < lore.size(); ++i) {
                if (!PatternUtils.USES_LEFT_LORE.matcher((CharSequence)lore.get(i)).matches()) continue;
                lore.set(i, newLine);
                itemMeta.setLore(lore);
                itemStack.setItemMeta(itemMeta);
                return;
            }
        } else {
            itemMeta.setLore(Collections.singletonList(newLine));
            itemStack.setItemMeta(itemMeta);
        }
    }
}

