/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.metalib.external;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class GlowingEntities
implements Listener {
    private final Plugin plugin;
    private Map<Player, PlayerData> glowing;
    private boolean enabled = false;
    private int uuid;

    public GlowingEntities(Plugin plugin) {
        if (!Packets.enabled) {
            throw new IllegalStateException("The Glowing Entities API is disabled. An error has occured during initialization.");
        }
        this.plugin = plugin;
        this.enable();
    }

    public void enable() {
        if (this.enabled) {
            throw new IllegalStateException("The Glowing Entities API has already been enabled.");
        }
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, this.plugin);
        this.glowing = new HashMap<Player, PlayerData>();
        this.uuid = ThreadLocalRandom.current().nextInt(Integer.MAX_VALUE);
        this.enabled = true;
    }

    public void disable() {
        if (!this.enabled) {
            return;
        }
        HandlerList.unregisterAll((Listener)this);
        this.glowing.values().forEach(playerData -> {
            try {
                Packets.removePacketsHandler(playerData);
            }
            catch (ReflectiveOperationException e) {
                e.printStackTrace();
            }
        });
        this.glowing = null;
        this.uuid = 0;
        this.enabled = false;
    }

    private void ensureEnabled() {
        if (!this.enabled) {
            throw new IllegalStateException("The Glowing Entities API is not enabled.");
        }
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        this.glowing.remove(event.getPlayer());
    }

    public boolean isGlowing(Entity entity, Player receiver) {
        this.ensureEnabled();
        return this.glowing.get(receiver) != null && this.glowing.get((Object)receiver).glowingDatas.containsKey(entity.getEntityId());
    }

    public void setGlowing(Entity entity, Player receiver) throws ReflectiveOperationException {
        this.setGlowing(entity, receiver, null);
    }

    public void setGlowing(Entity entity, Player receiver, ChatColor color) throws ReflectiveOperationException {
        String teamID = entity instanceof Player ? entity.getName() : entity.getUniqueId().toString();
        this.setGlowing(entity.getEntityId(), teamID, receiver, color, Packets.getEntityFlags(entity));
    }

    public void setGlowing(int entityID, String teamID, Player receiver) throws ReflectiveOperationException {
        this.setGlowing(entityID, teamID, receiver, null, (byte)0);
    }

    public void setGlowing(int entityID, String teamID, Player receiver, ChatColor color) throws ReflectiveOperationException {
        this.setGlowing(entityID, teamID, receiver, color, (byte)0);
    }

    public void setGlowing(int entityID, String teamID, Player receiver, ChatColor color, byte otherFlags) throws ReflectiveOperationException {
        GlowingData glowingData;
        this.ensureEnabled();
        if (color != null && !color.isColor()) {
            throw new IllegalArgumentException("ChatColor must be a color format");
        }
        PlayerData playerData = this.glowing.get(receiver);
        if (playerData == null) {
            playerData = new PlayerData(this, receiver);
            Packets.addPacketsHandler(playerData);
            this.glowing.put(receiver, playerData);
        }
        if ((glowingData = playerData.glowingDatas.get(entityID)) == null) {
            glowingData = new GlowingData(playerData, entityID, teamID, color, otherFlags);
            playerData.glowingDatas.put(entityID, glowingData);
            Packets.createGlowing(glowingData);
            if (color != null) {
                Packets.setGlowingColor(glowingData);
            }
        } else {
            if (Objects.equals(glowingData.color, color)) {
                return;
            }
            if (color == null) {
                Packets.removeGlowingColor(glowingData);
                glowingData.color = color;
            } else {
                glowingData.color = color;
                Packets.setGlowingColor(glowingData);
            }
        }
    }

    public void unsetGlowing(Entity entity, Player receiver) throws ReflectiveOperationException {
        this.unsetGlowing(entity.getEntityId(), receiver);
    }

    public void unsetGlowing(int entityID, Player receiver) throws ReflectiveOperationException {
        this.ensureEnabled();
        PlayerData playerData = this.glowing.get(receiver);
        if (playerData == null) {
            return;
        }
        GlowingData glowingData = playerData.glowingDatas.remove(entityID);
        if (glowingData == null) {
            return;
        }
        Packets.removeGlowing(glowingData);
        if (glowingData.color != null) {
            Packets.removeGlowingColor(glowingData);
        }
    }

    private static class Packets {
        private static final byte GLOWING_FLAG = 64;
        private static Cache<Object, Object> packets = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.SECONDS).build();
        private static Object dummy = new Object();
        private static Logger logger;
        private static int version;
        private static int versionMinor;
        private static String cpack;
        private static ProtocolMappings mappings;
        public static boolean enabled;
        private static Method getHandle;
        private static Method getDataWatcher;
        private static Object watcherObjectFlags;
        private static Object watcherDummy;
        private static Method watcherGet;
        private static Constructor<?> watcherItemConstructor;
        private static Method watcherItemObject;
        private static Method watcherItemDataGet;
        private static Method watcherBCreator;
        private static Method watcherBId;
        private static Method watcherBSerializer;
        private static Method watcherSerializerObject;
        private static Field playerConnection;
        private static Method sendPacket;
        private static Field networkManager;
        private static Field channelField;
        private static Class<?> packetMetadata;
        private static Constructor<?> packetMetadataConstructor;
        private static Field packetMetadataEntity;
        private static Field packetMetadataItems;
        private static Class<?> packetBundle;
        private static Method packetBundlePackets;
        private static EnumMap<ChatColor, TeamData> teams;
        private static Constructor<?> createTeamPacket;
        private static Constructor<?> createTeamPacketData;
        private static Constructor<?> createTeam;
        private static Object scoreboardDummy;
        private static Object pushNever;
        private static Method setTeamPush;
        private static Method setTeamColor;
        private static Method getColorConstant;

        private Packets() {
        }

        public static void sendPackets(Player p, Object ... packets) throws ReflectiveOperationException {
            Object connection = playerConnection.get(getHandle.invoke((Object)p, new Object[0]));
            for (Object packet : packets) {
                if (packet == null) continue;
                sendPacket.invoke(connection, packet);
            }
        }

        public static byte getEntityFlags(Entity entity) throws ReflectiveOperationException {
            Object nmsEntity = getHandle.invoke((Object)entity, new Object[0]);
            Object dataWatcher = getDataWatcher.invoke(nmsEntity, new Object[0]);
            return (Byte)watcherGet.invoke(dataWatcher, watcherObjectFlags);
        }

        public static void createGlowing(GlowingData glowingData) throws ReflectiveOperationException {
            Packets.setMetadata(glowingData, Packets.computeFlags(glowingData));
        }

        private static byte computeFlags(GlowingData glowingData) {
            byte newFlags = glowingData.otherFlags;
            newFlags = glowingData.enabled ? (byte)(newFlags | 0x40) : (byte)(newFlags & 0xFFFFFFBF);
            return newFlags;
        }

        public static Object createFlagWatcherItem(byte newFlags) throws ReflectiveOperationException {
            return watcherItemConstructor != null ? watcherItemConstructor.newInstance(watcherObjectFlags, newFlags) : watcherBCreator.invoke(null, watcherObjectFlags, newFlags);
        }

        public static void removeGlowing(GlowingData glowingData) throws ReflectiveOperationException {
            Packets.setMetadata(glowingData, glowingData.otherFlags);
        }

        public static void updateGlowingState(GlowingData glowingData) throws ReflectiveOperationException {
            if (glowingData.enabled) {
                Packets.createGlowing(glowingData);
            } else {
                Packets.removeGlowing(glowingData);
            }
        }

        private static void setMetadata(GlowingData glowingData, byte flags) throws ReflectiveOperationException {
            Object packetMetadata;
            ArrayList dataItems = new ArrayList(1);
            dataItems.add(watcherItemConstructor != null ? watcherItemConstructor.newInstance(watcherObjectFlags, flags) : watcherBCreator.invoke(null, watcherObjectFlags, flags));
            if (version < 19 || version == 19 && versionMinor < 3) {
                packetMetadata = packetMetadataConstructor.newInstance(glowingData.entityID, watcherDummy, false);
                packetMetadataItems.set(packetMetadata, dataItems);
            } else {
                packetMetadata = packetMetadataConstructor.newInstance(glowingData.entityID, dataItems);
            }
            packets.put(packetMetadata, dummy);
            Packets.sendPackets(glowingData.player.player, packetMetadata);
        }

        public static void setGlowingColor(GlowingData glowingData) throws ReflectiveOperationException {
            boolean sendCreation = false;
            if (glowingData.player.sentColors == null) {
                glowingData.player.sentColors = EnumSet.of(glowingData.color);
                sendCreation = true;
            } else if (glowingData.player.sentColors.add(glowingData.color)) {
                sendCreation = true;
            }
            TeamData teamData = teams.get(glowingData.color);
            if (teamData == null) {
                teamData = new TeamData(glowingData.player.instance.uuid, glowingData.color);
                teams.put(glowingData.color, teamData);
            }
            Object entityAddPacket = teamData.getEntityAddPacket(glowingData.teamID);
            if (sendCreation) {
                Packets.sendPackets(glowingData.player.player, teamData.creationPacket, entityAddPacket);
            } else {
                Packets.sendPackets(glowingData.player.player, entityAddPacket);
            }
        }

        public static void removeGlowingColor(GlowingData glowingData) throws ReflectiveOperationException {
            TeamData teamData = teams.get(glowingData.color);
            if (teamData == null) {
                return;
            }
            Packets.sendPackets(glowingData.player.player, teamData.getEntityRemovePacket(glowingData.teamID));
        }

        private static Channel getChannel(Player player) throws ReflectiveOperationException {
            return (Channel)channelField.get(networkManager.get(playerConnection.get(getHandle.invoke((Object)player, new Object[0]))));
        }

        public static void addPacketsHandler(final PlayerData playerData) throws ReflectiveOperationException {
            playerData.packetsHandler = new ChannelDuplexHandler(){

                public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
                    if (msg.getClass().equals(packetMetadata) && packets.asMap().remove(msg) == null) {
                        ArrayList<Object> items;
                        int entityID = packetMetadataEntity.getInt(msg);
                        GlowingData glowingData = playerData.glowingDatas.get(entityID);
                        if (glowingData != null && (items = (ArrayList<Object>)packetMetadataItems.get(msg)) != null) {
                            byte flags;
                            boolean containsFlags = false;
                            boolean edited = false;
                            for (int i = 0; i < items.size(); ++i) {
                                byte flags2;
                                Object watcherObject;
                                Object item = items.get(i);
                                if (watcherItemObject != null) {
                                    watcherObject = watcherItemObject.invoke(item, new Object[0]);
                                } else {
                                    Object serializer = watcherBSerializer.invoke(item, new Object[0]);
                                    watcherObject = watcherSerializerObject.invoke(serializer, watcherBId.invoke(item, new Object[0]));
                                }
                                if (!watcherObject.equals(watcherObjectFlags)) continue;
                                containsFlags = true;
                                glowingData.otherFlags = flags2 = ((Byte)watcherItemDataGet.invoke(item, new Object[0])).byteValue();
                                byte newFlags = Packets.computeFlags(glowingData);
                                if (newFlags == flags2) continue;
                                edited = true;
                                items = new ArrayList(items);
                                items.set(i, Packets.createFlagWatcherItem(newFlags));
                                break;
                            }
                            if (!edited && !containsFlags && (flags = Packets.computeFlags(glowingData)) != 0) {
                                edited = true;
                                items = new ArrayList<Object>(items);
                                items.add(Packets.createFlagWatcherItem(flags));
                            }
                            if (edited) {
                                Object newMsg;
                                if (version < 19 || version == 19 && versionMinor < 3) {
                                    newMsg = packetMetadataConstructor.newInstance(entityID, watcherDummy, false);
                                    packetMetadataItems.set(newMsg, items);
                                } else {
                                    newMsg = packetMetadataConstructor.newInstance(entityID, items);
                                }
                                packets.put(newMsg, dummy);
                                Packets.sendPackets(playerData.player, newMsg);
                                return;
                            }
                        }
                    } else if (packetBundle != null && msg.getClass().equals(packetBundle)) {
                        this.handlePacketBundle(msg);
                    }
                    super.write(ctx, msg, promise);
                }

                private void handlePacketBundle(Object bundle) throws ReflectiveOperationException {
                    Iterable subPackets = (Iterable)packetBundlePackets.invoke(bundle, new Object[0]);
                    for (Object packet : subPackets) {
                        int entityID;
                        GlowingData glowingData;
                        if (!packet.getClass().equals(packetMetadata) || (glowingData = playerData.glowingDatas.get(entityID = packetMetadataEntity.getInt(packet))) == null) continue;
                        Bukkit.getScheduler().runTaskLaterAsynchronously(playerData.instance.plugin, () -> {
                            try {
                                Packets.updateGlowingState(glowingData);
                            }
                            catch (ReflectiveOperationException e) {
                                e.printStackTrace();
                            }
                        }, 1L);
                        return;
                    }
                }
            };
            Packets.getChannel(playerData.player).pipeline().addBefore("packet_handler", null, playerData.packetsHandler);
        }

        public static void removePacketsHandler(PlayerData playerData) throws ReflectiveOperationException {
            if (playerData.packetsHandler != null) {
                Packets.getChannel(playerData.player).pipeline().remove(playerData.packetsHandler);
            }
        }

        private static Method getMethod(Class<?> clazz, String name) throws NoSuchMethodException {
            for (Method m : clazz.getDeclaredMethods()) {
                if (!m.getName().equals(name)) continue;
                return m;
            }
            throw new NoSuchMethodException(name + " in " + clazz.getName());
        }

        @Deprecated
        private static Object getField(Class<?> clazz, String name, Object instance) throws ReflectiveOperationException {
            return Packets.getField(clazz, name).get(instance);
        }

        private static Field getField(Class<?> clazz, String name) throws ReflectiveOperationException {
            Field field = clazz.getDeclaredField(name);
            field.setAccessible(true);
            return field;
        }

        private static Class<?> getCraftClass(String craftPackage, String className) throws ClassNotFoundException {
            return Class.forName(cpack + craftPackage + "." + className);
        }

        private static Class<?> getNMSClass(String className) throws ClassNotFoundException {
            return Class.forName("net.minecraft." + className);
        }

        private static Class<?> getNMSClass(String nmPackage, String className) throws ClassNotFoundException {
            return Class.forName("net.minecraft." + nmPackage + "." + className);
        }

        static {
            cpack = Bukkit.getServer().getClass().getPackage().getName() + ".";
            enabled = false;
            teams = new EnumMap(ChatColor.class);
            try {
                logger = new Logger("GlowingEntities", null){

                    @Override
                    public void log(LogRecord logRecord) {
                        logRecord.setMessage("[GlowingEntities] " + logRecord.getMessage());
                        super.log(logRecord);
                    }
                };
                logger.setParent(Bukkit.getServer().getLogger());
                logger.setLevel(Level.ALL);
                String[] versions = Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3].substring(1).split("_");
                version = Integer.parseInt(versions[1]);
                versions = Bukkit.getBukkitVersion().split("-R")[0].split("\\.");
                versionMinor = versions.length <= 2 ? 0 : Integer.parseInt(versions[2]);
                logger.info("Found server version 1." + version + "." + versionMinor);
                mappings = ProtocolMappings.getMappings(version);
                if (mappings == null) {
                    mappings = ProtocolMappings.values()[ProtocolMappings.values().length - 1];
                    logger.warning("Loaded not matching version of the mappings for your server version (1." + version + "." + versionMinor + ")");
                }
                logger.info("Loaded mappings " + mappings.name());
                Class<?> entityClass = Packets.getNMSClass("world.entity", "Entity");
                Class<?> entityTypesClass = Packets.getNMSClass("world.entity", "EntityTypes");
                Object markerEntity = Packets.getNMSClass("world.entity", "Marker").getDeclaredConstructors()[0].newInstance(Packets.getField(entityTypesClass, mappings.getMarkerTypeId(), null), null);
                getHandle = Packets.getCraftClass("entity", "CraftEntity").getDeclaredMethod("getHandle", new Class[0]);
                getDataWatcher = entityClass.getDeclaredMethod(mappings.getWatcherAccessor(), new Class[0]);
                Class<?> dataWatcherClass = Packets.getNMSClass("network.syncher", "DataWatcher");
                watcherObjectFlags = Packets.getField(entityClass, mappings.getWatcherFlags(), null);
                watcherDummy = dataWatcherClass.getDeclaredConstructor(entityClass).newInstance(markerEntity);
                Method method = watcherGet = version >= 18 ? dataWatcherClass.getDeclaredMethod("a", watcherObjectFlags.getClass()) : Packets.getMethod(dataWatcherClass, "get");
                if (version < 19 || version == 19 && versionMinor < 3) {
                    Class<?> watcherItem = Packets.getNMSClass("network.syncher", "DataWatcher$Item");
                    watcherItemConstructor = watcherItem.getDeclaredConstructor(watcherObjectFlags.getClass(), Object.class);
                    watcherItemObject = watcherItem.getDeclaredMethod("a", new Class[0]);
                    watcherItemDataGet = watcherItem.getDeclaredMethod("b", new Class[0]);
                } else {
                    Class<?> watcherB = Packets.getNMSClass("network.syncher", "DataWatcher$b");
                    watcherBCreator = watcherB.getDeclaredMethod("a", watcherObjectFlags.getClass(), Object.class);
                    watcherBId = watcherB.getDeclaredMethod("a", new Class[0]);
                    watcherBSerializer = watcherB.getDeclaredMethod("b", new Class[0]);
                    watcherItemDataGet = watcherB.getDeclaredMethod("c", new Class[0]);
                    watcherSerializerObject = Packets.getNMSClass("network.syncher", "DataWatcherSerializer").getDeclaredMethod("a", Integer.TYPE);
                }
                playerConnection = Packets.getNMSClass("server.level", "EntityPlayer").getDeclaredField(mappings.getPlayerConnection());
                sendPacket = Packets.getNMSClass("server.network", "PlayerConnection").getMethod(mappings.getSendPacket(), Packets.getNMSClass("network.protocol", "Packet"));
                networkManager = Packets.getNMSClass("server.network", "PlayerConnection").getDeclaredField(mappings.getNetworkManager());
                channelField = Packets.getNMSClass("network", "NetworkManager").getDeclaredField(mappings.getChannel());
                packetMetadata = Packets.getNMSClass("network.protocol.game", "PacketPlayOutEntityMetadata");
                packetMetadataEntity = Packets.getField(packetMetadata, mappings.getMetadataEntity());
                packetMetadataItems = Packets.getField(packetMetadata, mappings.getMetadataItems());
                packetMetadataConstructor = version < 19 || version == 19 && versionMinor < 3 ? packetMetadata.getDeclaredConstructor(Integer.TYPE, dataWatcherClass, Boolean.TYPE) : packetMetadata.getDeclaredConstructor(Integer.TYPE, List.class);
                if (version > 19 || version == 19 && versionMinor >= 4) {
                    packetBundle = Packets.getNMSClass("network.protocol.game", "ClientboundBundlePacket");
                    packetBundlePackets = packetBundle.getMethod("a", new Class[0]);
                }
                Class<?> scoreboardClass = Packets.getNMSClass("world.scores", "Scoreboard");
                Class<?> teamClass = Packets.getNMSClass("world.scores", "ScoreboardTeam");
                Class<?> pushClass = Packets.getNMSClass("world.scores", "ScoreboardTeamBase$EnumTeamPush");
                Class<?> chatFormatClass = Packets.getNMSClass("EnumChatFormat");
                createTeamPacket = Packets.getNMSClass("network.protocol.game", "PacketPlayOutScoreboardTeam").getDeclaredConstructor(String.class, Integer.TYPE, Optional.class, Collection.class);
                createTeamPacket.setAccessible(true);
                createTeamPacketData = Packets.getNMSClass("network.protocol.game", "PacketPlayOutScoreboardTeam$b").getDeclaredConstructor(teamClass);
                createTeam = teamClass.getDeclaredConstructor(scoreboardClass, String.class);
                scoreboardDummy = scoreboardClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                pushNever = pushClass.getDeclaredField("b").get(null);
                setTeamPush = teamClass.getDeclaredMethod(mappings.getTeamSetCollision(), pushClass);
                setTeamColor = teamClass.getDeclaredMethod(mappings.getTeamSetColor(), chatFormatClass);
                getColorConstant = chatFormatClass.getDeclaredMethod("a", Character.TYPE);
                enabled = true;
            }
            catch (Exception ex) {
                String errorMsg = "Glowing Entities reflection failed to initialize. The util is disabled. Please ensure your version (" + Bukkit.getServer().getClass().getPackage().getName() + ") is supported.";
                if (logger == null) {
                    ex.printStackTrace();
                    System.err.println(errorMsg);
                }
                logger.log(Level.SEVERE, errorMsg, ex);
            }
        }

        private static class TeamData {
            private final String id;
            private final Object creationPacket;
            private final Cache<String, Object> addPackets = CacheBuilder.newBuilder().expireAfterAccess(3L, TimeUnit.MINUTES).build();
            private final Cache<String, Object> removePackets = CacheBuilder.newBuilder().expireAfterAccess(3L, TimeUnit.MINUTES).build();

            public TeamData(int uuid, ChatColor color) throws ReflectiveOperationException {
                if (!color.isColor()) {
                    throw new IllegalArgumentException();
                }
                this.id = "glow-" + uuid + color.getChar();
                Object team = createTeam.newInstance(scoreboardDummy, this.id);
                setTeamPush.invoke(team, pushNever);
                setTeamColor.invoke(team, getColorConstant.invoke(null, Character.valueOf(color.getChar())));
                Object packetData = createTeamPacketData.newInstance(team);
                this.creationPacket = createTeamPacket.newInstance(this.id, 0, Optional.of(packetData), Collections.EMPTY_LIST);
            }

            public Object getEntityAddPacket(String teamID) throws ReflectiveOperationException {
                Object packet = this.addPackets.getIfPresent((Object)teamID);
                if (packet == null) {
                    packet = createTeamPacket.newInstance(this.id, 3, Optional.empty(), Arrays.asList(teamID));
                    this.addPackets.put((Object)teamID, packet);
                }
                return packet;
            }

            public Object getEntityRemovePacket(String teamID) throws ReflectiveOperationException {
                Object packet = this.removePackets.getIfPresent((Object)teamID);
                if (packet == null) {
                    packet = createTeamPacket.newInstance(this.id, 4, Optional.empty(), Arrays.asList(teamID));
                    this.removePackets.put((Object)teamID, packet);
                }
                return packet;
            }
        }

        private static enum ProtocolMappings {
            V1_17(17, "Z", "Y", "getDataWatcher", "b", "a", "sendPacket", "k", "setCollisionRule", "setColor", "a", "b"),
            V1_18(18, "Z", "Y", "ai", "b", "a", "a", "m", "a", "a", "a", "b"),
            V1_19(19, null, "ab", null, "b", null, "a", "m", "a", "a", null, null){

                @Override
                public String getNetworkManager() {
                    return versionMinor < 4 ? "b" : "h";
                }

                @Override
                public String getWatcherFlags() {
                    return versionMinor < 4 ? "Z" : "an";
                }

                @Override
                public String getWatcherAccessor() {
                    if (versionMinor < 3) {
                        return "ai";
                    }
                    if (versionMinor == 3) {
                        return "al";
                    }
                    return "aj";
                }

                @Override
                public String getMetadataEntity() {
                    return versionMinor < 3 ? "a" : "b";
                }

                @Override
                public String getMetadataItems() {
                    return versionMinor < 3 ? "b" : "c";
                }
            };

            private final int major;
            private final String watcherFlags;
            private final String markerTypeId;
            private final String watcherAccessor;
            private final String playerConnection;
            private final String networkManager;
            private final String sendPacket;
            private final String channel;
            private final String teamSetCollsion;
            private final String teamSetColor;
            private final String metadataEntity;
            private final String metadataItems;

            private ProtocolMappings(int major, String watcherFlags, String markerTypeId, String watcherAccessor, String playerConnection, String networkManager, String sendPacket, String channel, String teamSetCollsion, String teamSetColor, String metdatataEntity, String metadataItems) {
                this.major = major;
                this.watcherFlags = watcherFlags;
                this.markerTypeId = markerTypeId;
                this.watcherAccessor = watcherAccessor;
                this.playerConnection = playerConnection;
                this.networkManager = networkManager;
                this.sendPacket = sendPacket;
                this.channel = channel;
                this.teamSetCollsion = teamSetCollsion;
                this.teamSetColor = teamSetColor;
                this.metadataEntity = metdatataEntity;
                this.metadataItems = metadataItems;
            }

            public int getMajor() {
                return this.major;
            }

            public String getWatcherFlags() {
                return this.watcherFlags;
            }

            public String getMarkerTypeId() {
                return this.markerTypeId;
            }

            public String getWatcherAccessor() {
                return this.watcherAccessor;
            }

            public String getPlayerConnection() {
                return this.playerConnection;
            }

            public String getNetworkManager() {
                return this.networkManager;
            }

            public String getSendPacket() {
                return this.sendPacket;
            }

            public String getChannel() {
                return this.channel;
            }

            public String getTeamSetCollision() {
                return this.teamSetCollsion;
            }

            public String getTeamSetColor() {
                return this.teamSetColor;
            }

            public String getMetadataEntity() {
                return this.metadataEntity;
            }

            public String getMetadataItems() {
                return this.metadataItems;
            }

            public static ProtocolMappings getMappings(int major) {
                for (ProtocolMappings map : ProtocolMappings.values()) {
                    if (major != map.getMajor()) continue;
                    return map;
                }
                return null;
            }
        }
    }

    private static class PlayerData {
        final GlowingEntities instance;
        final Player player;
        final Map<Integer, GlowingData> glowingDatas;
        ChannelHandler packetsHandler;
        EnumSet<ChatColor> sentColors;

        PlayerData(GlowingEntities instance, Player player) {
            this.instance = instance;
            this.player = player;
            this.glowingDatas = new HashMap<Integer, GlowingData>();
        }
    }

    private static class GlowingData {
        final PlayerData player;
        final int entityID;
        final String teamID;
        ChatColor color;
        byte otherFlags;
        boolean enabled;

        GlowingData(PlayerData player, int entityID, String teamID, ChatColor color, byte otherFlags) {
            this.player = player;
            this.entityID = entityID;
            this.teamID = teamID;
            this.color = color;
            this.otherFlags = otherFlags;
            this.enabled = true;
        }
    }
}

