/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.displaymodellib.sefilib.entity;

import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;
import org.metamechanists.displaymodellib.sefilib.protections.Protections;

public final class EntityUtils {
    private EntityUtils() {
        throw new IllegalStateException("Utility class");
    }

    @ParametersAreNonnullByDefault
    public static void healEntity(LivingEntity livingEntity, double healAmount) {
        AttributeInstance attribute = livingEntity.getAttribute(Attribute.GENERIC_MAX_HEALTH);
        if (attribute != null) {
            livingEntity.setHealth(Math.min(attribute.getValue(), livingEntity.getHealth() + healAmount));
        }
    }

    @ParametersAreNonnullByDefault
    public static boolean damageEntity(LivingEntity livingEntity, UUID player, double damage) {
        return EntityUtils.damageEntity(livingEntity, player, damage, null, 0.0);
    }

    @ParametersAreNonnullByDefault
    public static boolean damageEntity(LivingEntity livingEntity, UUID playerUUID, double damage, @Nullable Location knockbackOrigin, double knockbackForce) {
        Interaction interaction;
        Interaction interaction2 = interaction = livingEntity instanceof Player ? Interaction.ATTACK_PLAYER : Interaction.ATTACK_ENTITY;
        if (Protections.hasPermission(playerUUID, livingEntity.getLocation(), interaction)) {
            Player player = Bukkit.getPlayer((UUID)playerUUID);
            livingEntity.damage(damage, (Entity)player);
            if (knockbackOrigin != null && knockbackForce > 0.0) {
                EntityUtils.pushEntity(playerUUID, knockbackOrigin, (Entity)livingEntity, knockbackForce);
            }
            return true;
        }
        return false;
    }

    @ParametersAreNonnullByDefault
    public static boolean pullEntity(UUID originatingPlayer, Location pullToLocation, Entity pushed, double force) {
        Vector vector = pushed.getLocation().toVector().subtract(pullToLocation.toVector()).normalize().multiply(-force);
        return EntityUtils.pushEntity(originatingPlayer, vector, pushed);
    }

    @ParametersAreNonnullByDefault
    public static boolean pushEntity(UUID originatingPlayer, Location pushFromLocation, Entity pushed, double force) {
        Vector vector = pushed.getLocation().toVector().subtract(pushFromLocation.toVector()).normalize().multiply(force);
        return EntityUtils.pushEntity(originatingPlayer, vector, pushed);
    }

    @ParametersAreNonnullByDefault
    public static boolean pushEntity(UUID originatingPlayer, Vector vector, Entity pushed) {
        Interaction interaction;
        Interaction interaction2 = interaction = pushed instanceof Player ? Interaction.ATTACK_PLAYER : Interaction.INTERACT_ENTITY;
        if (Protections.hasPermission(originatingPlayer, pushed.getLocation(), interaction)) {
            pushed.setVelocity(vector);
            return true;
        }
        return false;
    }

    public static double getFacing(@Nonnull Entity testEntity, @Nonnull Entity compareEntity) {
        Vector pd = testEntity.getLocation().getDirection();
        Vector ed = compareEntity.getLocation().getDirection();
        double x = pd.getX() * ed.getZ() - pd.getZ() * ed.getX();
        double z = pd.getX() * ed.getX() + pd.getZ() * ed.getZ();
        double a = Math.atan2(x, z);
        return a * 180.0 / Math.PI;
    }

    public static boolean isFacingAway(@Nonnull Entity testEntity, @Nonnull Entity compareEntity) {
        return EntityUtils.isFacingAway(testEntity, compareEntity, null);
    }

    public static boolean isFacingAway(@Nonnull Entity testEntity, @Nonnull Entity compareEntity, @Nullable Integer tolerance) {
        double d = EntityUtils.getFacing(testEntity, compareEntity);
        int val = tolerance == null ? 30 : tolerance;
        return d <= (double)val && d >= (double)(-val);
    }
}

