/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.buildingstaff.core.managers;

import com.balugaq.buildingstaff.api.interfaces.IManager;
import com.balugaq.buildingstaff.core.listeners.PlayerInteractListener;
import com.balugaq.buildingstaff.core.listeners.PrepareBreakingListener;
import com.balugaq.buildingstaff.core.listeners.PrepareBuildingListener;
import com.balugaq.buildingstaff.core.listeners.StaffModeSwitchListener;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ListenerManager
implements IManager {
    private final JavaPlugin plugin;
    private final List<Listener> listeners = new ArrayList<Listener>();

    public ListenerManager(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void setup() {
        this.listeners.add(new PrepareBuildingListener());
        this.listeners.add(new PrepareBreakingListener());
        this.listeners.add(new PlayerInteractListener());
        this.listeners.add(new StaffModeSwitchListener());
        for (Listener listener : this.listeners) {
            Bukkit.getServer().getPluginManager().registerEvents(listener, (Plugin)this.plugin);
        }
    }

    @Override
    public void shutdown() {
        for (Listener listener : this.listeners) {
            HandlerList.unregisterAll((Listener)listener);
        }
        this.listeners.clear();
    }
}

