/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.buildingstaff.api.items;

import com.balugaq.buildingstaff.api.items.Staff;
import com.balugaq.buildingstaff.utils.StaffUtil;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.FluidCollisionMode;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public abstract class BreakingStaff
extends SlimefunItem
implements Staff {
    private final int limitBlocks;
    private final boolean blockStrict;
    private final boolean opOnly;

    public BreakingStaff(@NotNull ItemGroup itemGroup, @NotNull SlimefunItemStack item, @NotNull RecipeType recipeType, ItemStack @NotNull [] recipe, int limitBlocks, boolean blockStrict, boolean opOnly) {
        super(itemGroup, item, recipeType, recipe);
        this.limitBlocks = limitBlocks;
        this.blockStrict = blockStrict;
        this.opOnly = opOnly;
    }

    @NotNull
    private static BlockFace getBlockFaceAsCartesian(@NotNull BlockFace originalFacing) {
        BlockFace lookingFacing = originalFacing.getOppositeFace();
        if (!originalFacing.isCartesian()) {
            switch (originalFacing) {
                case NORTH_EAST: 
                case NORTH_WEST: 
                case NORTH_NORTH_EAST: 
                case NORTH_NORTH_WEST: {
                    lookingFacing = BlockFace.NORTH;
                    break;
                }
                case SOUTH_EAST: 
                case SOUTH_WEST: 
                case SOUTH_SOUTH_EAST: 
                case SOUTH_SOUTH_WEST: {
                    lookingFacing = BlockFace.SOUTH;
                    break;
                }
                case EAST_NORTH_EAST: 
                case EAST_SOUTH_EAST: {
                    lookingFacing = BlockFace.EAST;
                    break;
                }
                case WEST_NORTH_WEST: 
                case WEST_SOUTH_WEST: {
                    lookingFacing = BlockFace.WEST;
                    break;
                }
            }
        }
        return lookingFacing;
    }

    public void preRegister() {
        super.preRegister();
        this.addItemHandler(new ItemHandler[]{playerRightClickEvent -> {
            if (playerRightClickEvent.getInteractEvent().getHand() != EquipmentSlot.HAND) {
                return;
            }
            Player player = playerRightClickEvent.getPlayer();
            if (this.opOnly && !player.isOp()) {
                return;
            }
            if (player.getGameMode() == GameMode.SPECTATOR) {
                return;
            }
            if (this.isDisabledIn(player.getWorld())) {
                return;
            }
            Block lookingAtBlock = player.getTargetBlockExact(6, FluidCollisionMode.NEVER);
            if (lookingAtBlock == null || lookingAtBlock.getType() == Material.AIR) {
                return;
            }
            Material material = lookingAtBlock.getType();
            if (this.isDisabledMaterial(material)) {
                return;
            }
            BlockFace originalFacing = player.getTargetBlockFace(6, FluidCollisionMode.NEVER);
            if (originalFacing == null) {
                return;
            }
            Location lookingLocation = lookingAtBlock.getLocation();
            BlockFace lookingFacing = BreakingStaff.getBlockFaceAsCartesian(originalFacing);
            ItemStack item = player.getInventory().getItemInMainHand();
            Set<Location> rawLocations = StaffUtil.getRawLocations(lookingAtBlock, lookingFacing, this.limitBlocks, this.getAxis(item), this.blockStrict, true);
            World world = lookingLocation.getWorld();
            HashMap<Location, Double> distances = new HashMap<Location, Double>();
            for (Location location2 : rawLocations) {
                if (!world.getWorldBorder().isInside(location2)) continue;
                double distance = location2.distance(lookingLocation);
                distances.put(location2, distance);
            }
            HashSet locations = new HashSet(distances.keySet());
            List<Location> sortedLocations = locations.stream().sorted(Comparator.comparingDouble(distances::get)).toList();
            HashSet result = new HashSet();
            AtomicInteger count = new AtomicInteger(0);
            sortedLocations.forEach(location -> {
                if (count.incrementAndGet() > this.limitBlocks) {
                    return;
                }
                result.add(location);
            });
            HashSet<BlockBreakEvent> locationsToBreak = new HashSet<BlockBreakEvent>();
            for (Location location3 : result) {
                if (!Slimefun.getProtectionManager().hasPermission((OfflinePlayer)player, location3, Interaction.BREAK_BLOCK)) continue;
                BlockBreakEvent event = new BlockBreakEvent(location3.getBlock(), player);
                Bukkit.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) continue;
                locationsToBreak.add(event);
            }
            Bukkit.getScheduler().runTaskLater((Plugin)this.getAddon().getJavaPlugin(), () -> {
                for (BlockBreakEvent event : locationsToBreak) {
                    Block block;
                    if (event.isCancelled() || (block = event.getBlock()) == null) continue;
                    if (event.isDropItems()) {
                        block.breakNaturally();
                    } else {
                        block.setType(Material.AIR);
                    }
                    BlockState state = block.getState();
                    state.update(true, true);
                }
            }, 1L);
        }});
    }

    public boolean isDisabledMaterial(@NotNull Material material) {
        return material.isAir() || !material.isBlock() || material == Material.END_PORTAL_FRAME || material == Material.BEDROCK || material == Material.COMMAND_BLOCK || material == Material.CHAIN_COMMAND_BLOCK || material == Material.REPEATING_COMMAND_BLOCK || material == Material.STRUCTURE_VOID || material == Material.STRUCTURE_BLOCK || material == Material.JIGSAW || material == Material.BARRIER || material == Material.LIGHT || material == Material.SPAWNER || material == this.materialValueOf("TRIAL_SPAWNER") || material.getHardness() < 0.0f;
    }

    @NotNull
    private Material materialValueOf(String name) {
        try {
            return Material.valueOf((String)name);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return Material.AIR;
        }
    }

    @Generated
    public int getLimitBlocks() {
        return this.limitBlocks;
    }

    @Override
    @Generated
    public boolean isBlockStrict() {
        return this.blockStrict;
    }

    @Generated
    public boolean isOpOnly() {
        return this.opOnly;
    }
}

