/*
 * Decompiled with CFR 0.152.
 */
package dev.sefiraat.sefilib.slimefun.blocks;

import com.google.errorprone.annotations.OverridingMethodsMustInvokeSuper;
import dev.sefiraat.sefilib.slimefun.items.SefiSlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.events.PlayerRightClickEvent;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockPlaceHandler;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import org.bukkit.block.Block;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;

public abstract class SefiBlock<T extends SefiSlimefunItem<T>>
extends SefiSlimefunItem<T> {
    private boolean sync = true;
    private boolean allowBlockPlacers = false;
    private boolean allowAndroids = false;
    private boolean allowExplosions = false;

    protected SefiBlock(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
    }

    protected SefiBlock(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, @Nullable ItemStack recipeOutput) {
        super(itemGroup, item, recipeType, recipe, recipeOutput);
    }

    @Override
    protected T getThis() {
        return (T)((Object)this);
    }

    @OverridingMethodsMustInvokeSuper
    public void preRegister() {
        this.addItemHandler(new ItemHandler[]{new BlockPlaceHandler(this.allowBlockPlacers){

            public void onPlayerPlace(@Nonnull BlockPlaceEvent e) {
                SefiBlock.this.onBlockPlaced(e);
            }
        }, new BlockTicker(){

            public boolean isSynchronized() {
                return SefiBlock.this.sync;
            }

            @ParametersAreNonnullByDefault
            public void tick(Block block, SlimefunItem item, Config data) {
                SefiBlock.this.onTick(block, item, data);
            }

            public void uniqueTick() {
                SefiBlock.this.onUniqueTick();
            }
        }, this::onPlayerRightClickBlock, new BlockBreakHandler(this.allowAndroids, this.allowExplosions){

            @ParametersAreNonnullByDefault
            public void onPlayerBreak(BlockBreakEvent event, ItemStack item, List<ItemStack> drops) {
                SefiBlock.this.onPlayerBreaksBlock(event, item, drops);
            }
        }});
    }

    public boolean isSync() {
        return this.sync;
    }

    public T setSync(boolean sync) {
        this.sync = sync;
        return this.getThis();
    }

    public boolean isAllowBlockPlacers() {
        return this.allowBlockPlacers;
    }

    public T setAllowBlockPlacers(boolean allowBlockPlacers) {
        this.allowBlockPlacers = allowBlockPlacers;
        return this.getThis();
    }

    public boolean isAllowAndroids() {
        return this.allowAndroids;
    }

    public T setAllowAndroids(boolean allowAndroids) {
        this.allowAndroids = allowAndroids;
        return this.getThis();
    }

    public boolean isAllowExplosions() {
        return this.allowExplosions;
    }

    public T setAllowExplosions(boolean allowExplosions) {
        this.allowExplosions = allowExplosions;
        return this.getThis();
    }

    protected void onBlockPlaced(@Nonnull BlockPlaceEvent event) {
    }

    @ParametersAreNonnullByDefault
    protected void onTick(Block block, SlimefunItem item, Config data) {
    }

    protected void onUniqueTick() {
    }

    protected void onPlayerRightClickBlock(@Nonnull PlayerRightClickEvent event) {
    }

    @ParametersAreNonnullByDefault
    protected void onPlayerBreaksBlock(BlockBreakEvent event, ItemStack item, List<ItemStack> drops) {
    }
}

