/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.buildingstaff.utils;

import com.balugaq.buildingstaff.utils.ReflectionUtil;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.github.thebusybiscuit.slimefun4.libraries.dough.collections.Pair;
import java.lang.reflect.Field;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WorldUtils {
    @Nullable
    protected static Class<?> craftBlockStateClass;
    @Nullable
    protected static Field interfaceBlockDataField;
    @Nullable
    protected static Field blockPositionField;
    @Nullable
    protected static Field worldField;
    @Nullable
    protected static Field weakWorldField;
    protected static boolean success;

    @CanIgnoreReturnValue
    public static boolean copyBlockState(@Nonnull BlockState fromBlockState, @Nonnull Block toBlock) {
        if (!success) {
            return false;
        }
        BlockState toState = toBlock.getState();
        if (!craftBlockStateClass.isInstance(toState) || !craftBlockStateClass.isInstance(fromBlockState)) {
            return false;
        }
        try {
            blockPositionField.set(fromBlockState, blockPositionField.get(toState));
            worldField.set(fromBlockState, worldField.get(toState));
            weakWorldField.set(fromBlockState, weakWorldField.get(toState));
            fromBlockState.update(true, false);
            return true;
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    @NotNull
    public static String locationToString(@Nonnull Location l) {
        if (l == null) {
            return "Unknown Location";
        }
        if (l.getWorld() == null) {
            return "Unknown Location";
        }
        return l.getWorld().getName() + "," + l.getBlockX() + "," + l.getBlockY() + "," + l.getBlockZ();
    }

    public static long locationRange(@Nonnull Location pos1, @Nonnull Location pos2) {
        if (pos1 == null || pos2 == null) {
            return 0L;
        }
        int downX = Math.min(pos1.getBlockX(), pos2.getBlockX());
        int upX = Math.max(pos1.getBlockX(), pos2.getBlockX());
        int downY = Math.min(pos1.getBlockY(), pos2.getBlockY());
        int upY = Math.max(pos1.getBlockY(), pos2.getBlockY());
        int downZ = Math.min(pos1.getBlockZ(), pos2.getBlockZ());
        int upZ = Math.max(pos1.getBlockZ(), pos2.getBlockZ());
        return (long)(Math.abs(upX - downX) + 1) * (long)(Math.abs(upY - downY) + 1) * (long)(Math.abs(upZ - downZ) + 1);
    }

    public static void doWorldEdit(@Nonnull Location pos1, @Nonnull Location pos2, @Nonnull Consumer<Location> consumer) {
        if (pos1 == null || pos2 == null) {
            return;
        }
        int downX = Math.min(pos1.getBlockX(), pos2.getBlockX());
        int upX = Math.max(pos1.getBlockX(), pos2.getBlockX());
        int downY = Math.min(pos1.getBlockY(), pos2.getBlockY());
        int upY = Math.max(pos1.getBlockY(), pos2.getBlockY());
        int downZ = Math.min(pos1.getBlockZ(), pos2.getBlockZ());
        int upZ = Math.max(pos1.getBlockZ(), pos2.getBlockZ());
        for (int x = downX; x <= upX; ++x) {
            for (int y = downY; y <= upY; ++y) {
                for (int z = downZ; z <= upZ; ++z) {
                    consumer.accept(new Location(pos1.getWorld(), (double)x, (double)y, (double)z));
                }
            }
        }
    }

    public static long getRange(@Nonnull Location pos1, @Nonnull Location pos2) {
        if (pos1 == null || pos2 == null) {
            return 0L;
        }
        int downX = Math.min(pos1.getBlockX(), pos2.getBlockX());
        int upX = Math.max(pos1.getBlockX(), pos2.getBlockX());
        int downY = Math.min(pos1.getBlockY(), pos2.getBlockY());
        int upY = Math.max(pos1.getBlockY(), pos2.getBlockY());
        int downZ = Math.min(pos1.getBlockZ(), pos2.getBlockZ());
        int upZ = Math.max(pos1.getBlockZ(), pos2.getBlockZ());
        return (long)(Math.abs(upX - downX) + 1) * (long)(Math.abs(upY - downY) + 1) * (long)(Math.abs(upZ - downZ) + 1);
    }

    static {
        success = false;
        try {
            World sampleWorld = (World)Bukkit.getWorlds().get(0);
            BlockState blockstate = sampleWorld.getBlockAt(0, 0, 0).getState();
            Pair<Field, Class<?>> result = ReflectionUtil.getDeclaredFieldsRecursively(blockstate.getClass(), "data");
            interfaceBlockDataField = (Field)result.getFirstValue();
            interfaceBlockDataField.setAccessible(true);
            craftBlockStateClass = (Class)result.getSecondValue();
            blockPositionField = (Field)ReflectionUtil.getDeclaredFieldsRecursively(craftBlockStateClass, "position").getFirstValue();
            blockPositionField.setAccessible(true);
            worldField = (Field)ReflectionUtil.getDeclaredFieldsRecursively(craftBlockStateClass, "world").getFirstValue();
            worldField.setAccessible(true);
            weakWorldField = (Field)ReflectionUtil.getDeclaredFieldsRecursively(craftBlockStateClass, "weakWorld").getFirstValue();
            weakWorldField.setAccessible(true);
            success = true;
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

