/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.metalib.dough.versions;

import java.util.Objects;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import javax.annotation.Nonnull;
import org.apache.commons.lang.Validate;
import org.metamechanists.metalib.dough.common.CommonPatterns;
import org.metamechanists.metalib.dough.versions.IncomparableVersionsException;
import org.metamechanists.metalib.dough.versions.Version;

public class SemanticVersion
implements Version {
    private final int majorVersion;
    private final int minorVersion;
    private final int patchVersion;

    public SemanticVersion(int major, int minor, int patch) {
        Validate.isTrue((major >= 0 ? 1 : 0) != 0, (String)"Major version must be positive or zero.");
        Validate.isTrue((minor >= 0 ? 1 : 0) != 0, (String)"Minor version must be positive or zero.");
        Validate.isTrue((patch >= 0 ? 1 : 0) != 0, (String)"Patch version must be positive or zero.");
        this.majorVersion = major;
        this.minorVersion = minor;
        this.patchVersion = patch;
    }

    public SemanticVersion(int major, int minor) {
        this(major, minor, 0);
    }

    public final int getMajorVersion() {
        return this.majorVersion;
    }

    public final int getMinorVersion() {
        return this.minorVersion;
    }

    public final int getPatchVersion() {
        return this.patchVersion;
    }

    public final boolean isPatch() {
        return this.getPatchVersion() > 0;
    }

    public boolean isAtLeast(int major, int minor, int patch) {
        return this.isAtLeast(new SemanticVersion(major, minor, patch));
    }

    public boolean isAtLeast(int major, int minor) {
        return this.isAtLeast(major, minor, 0);
    }

    @Override
    public boolean isSimilar(Version version) {
        return version instanceof SemanticVersion;
    }

    @Override
    public boolean isNewerThan(@Nonnull Version version) {
        if (this.isSimilar(version)) {
            SemanticVersion semver = (SemanticVersion)version;
            int major = semver.getMajorVersion();
            if (this.getMajorVersion() > major) {
                return true;
            }
            if (major > this.getMajorVersion()) {
                return false;
            }
            int minor = semver.getMinorVersion();
            if (this.getMinorVersion() > minor) {
                return true;
            }
            if (minor > this.getMinorVersion()) {
                return false;
            }
            return this.getPatchVersion() > semver.getPatchVersion();
        }
        throw new IncomparableVersionsException(this, version);
    }

    @Override
    public boolean isEqualTo(@Nonnull Version version) {
        if (this.isSimilar(version)) {
            SemanticVersion semver = (SemanticVersion)version;
            int major = semver.getMajorVersion();
            if (major != this.getMajorVersion()) {
                return false;
            }
            int minor = semver.getMinorVersion();
            if (minor != this.getMinorVersion()) {
                return false;
            }
            return this.getPatchVersion() == semver.getPatchVersion();
        }
        throw new IncomparableVersionsException(this, version);
    }

    @Override
    public boolean isOlderThan(@Nonnull Version version) {
        if (this.isSimilar(version)) {
            SemanticVersion semver = (SemanticVersion)version;
            int major = semver.getMajorVersion();
            if (major > this.getMajorVersion()) {
                return true;
            }
            if (this.getMajorVersion() > major) {
                return false;
            }
            int minor = semver.getMinorVersion();
            if (minor > this.getMinorVersion()) {
                return true;
            }
            if (this.getMinorVersion() > minor) {
                return false;
            }
            return semver.getPatchVersion() > this.getPatchVersion();
        }
        throw new IncomparableVersionsException(this, version);
    }

    @Override
    @Nonnull
    public String getAsString() {
        if (this.isPatch()) {
            return this.majorVersion + "." + this.minorVersion + "." + this.patchVersion;
        }
        return this.majorVersion + "." + this.minorVersion;
    }

    public int hashCode() {
        return Objects.hash(this.majorVersion, this.minorVersion, this.patchVersion);
    }

    public boolean equals(Object obj) {
        if (obj instanceof SemanticVersion) {
            return this.isEqualTo((Version)obj);
        }
        return false;
    }

    public String toString() {
        return "SemanticVersion [" + this.getAsString() + "]";
    }

    public boolean equalsIgnorePatch(@Nonnull SemanticVersion version) {
        Validate.notNull((Object)version, (String)"Version cannot be null.");
        return this.equalsIgnorePatch(version.getMajorVersion(), version.getMinorVersion());
    }

    public boolean equalsIgnorePatch(int majorVersion, int minorVersion) {
        return this.majorVersion == majorVersion && this.minorVersion == minorVersion;
    }

    @Nonnull
    public static SemanticVersion parse(@Nonnull String version) {
        Validate.notNull((Object)version, (String)"The version should not be null.");
        Matcher matcher = CommonPatterns.SEMANTIC_VERSIONS.matcher(version);
        if (matcher.matches()) {
            MatchResult result = matcher.toMatchResult();
            int majorVersion = Integer.parseInt(result.group(1), 10);
            int minorVersion = Integer.parseInt(result.group(2), 10);
            int patchVersion = 0;
            if (result.group(3) != null) {
                patchVersion = Integer.parseInt(result.group(3), 10);
            }
            return new SemanticVersion(majorVersion, minorVersion, patchVersion);
        }
        throw new IllegalArgumentException("Could not parse \"" + version + "\" as a semantic version.");
    }
}

