/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.metalib.dough.protection.modules;

import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.permissions.PermissionHolder;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.util.Permissions;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.plugin.Plugin;
import org.metamechanists.metalib.dough.protection.Interaction;
import org.metamechanists.metalib.dough.protection.ProtectionModule;

public class PlotSquaredProtectionModule
implements ProtectionModule {
    private final Plugin plugin;

    public PlotSquaredProtectionModule(@Nonnull Plugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    public void load() {
    }

    @Override
    public boolean hasPermission(OfflinePlayer p, org.bukkit.Location l, Interaction action) {
        Block b = l.getBlock();
        Location location = Location.at((String)b.getWorld().getName(), (int)b.getX(), (int)b.getY(), (int)b.getZ());
        if (location.isPlotRoad()) {
            return this.check(p, action);
        }
        Plot plot = location.getOwnedPlot();
        return plot == null || plot.isAdded(p.getUniqueId()) || this.check(p, action);
    }

    @ParametersAreNonnullByDefault
    private boolean check(OfflinePlayer p, Interaction action) {
        PlotPlayer player = PlotPlayer.from((Object)p);
        switch (action) {
            case INTERACT_BLOCK: {
                return Permissions.hasPermission((PermissionHolder)player, (Permission)Permission.PERMISSION_ADMIN_INTERACT_UNOWNED);
            }
            case ATTACK_PLAYER: {
                return Permissions.hasPermission((PermissionHolder)player, (Permission)Permission.PERMISSION_ADMIN_PVP);
            }
        }
        return Permissions.hasPermission((PermissionHolder)player, (Permission)Permission.PERMISSION_ADMIN_BUILD_UNOWNED);
    }
}

