/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.buildingstaff.core.managers;

import com.balugaq.buildingstaff.api.interfaces.IManager;
import com.balugaq.buildingstaff.utils.Debug;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class ConfigManager
implements IManager {
    private final JavaPlugin plugin;

    public ConfigManager(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void setup() {
        this.loadConfig();
    }

    @Override
    public void shutdown() {
    }

    public void loadConfig() {
        this.setupDefaultConfig();
    }

    private void setupDefaultConfig() {
        InputStream inputStream = this.plugin.getResource("config.yml");
        File existingFile = new File(this.plugin.getDataFolder(), "config.yml");
        if (inputStream == null) {
            return;
        }
        InputStreamReader reader = new InputStreamReader(inputStream);
        YamlConfiguration resourceConfig = YamlConfiguration.loadConfiguration((Reader)reader);
        YamlConfiguration existingConfig = YamlConfiguration.loadConfiguration((File)existingFile);
        for (String key : resourceConfig.getKeys(false)) {
            this.checkKey((FileConfiguration)existingConfig, (FileConfiguration)resourceConfig, key);
        }
        try {
            existingConfig.save(existingFile);
        }
        catch (IOException e) {
            Debug.log(e);
        }
    }

    @ParametersAreNonnullByDefault
    private void checkKey(FileConfiguration existingConfig, FileConfiguration resourceConfig, String key) {
        Object currentValue = existingConfig.get(key);
        Object newValue = resourceConfig.get(key);
        if (newValue instanceof ConfigurationSection) {
            ConfigurationSection section = (ConfigurationSection)newValue;
            for (String sectionKey : section.getKeys(false)) {
                this.checkKey(existingConfig, resourceConfig, key + "." + sectionKey);
            }
        } else if (currentValue == null) {
            existingConfig.set(key, newValue);
        }
    }

    public boolean isAutoUpdate() {
        return this.plugin.getConfig().getBoolean("auto-update");
    }

    public boolean isDebug() {
        return this.plugin.getConfig().getBoolean("debug");
    }

    public boolean isDisplayProjection() {
        return this.plugin.getConfig().getBoolean("display-projection");
    }

    @Generated
    public JavaPlugin getPlugin() {
        return this.plugin;
    }
}

