/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.displaymodellib.builders;

import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.entity.Display;
import org.bukkit.entity.TextDisplay;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.metamechanists.displaymodellib.builders.DisplayBuilder;

public class TextDisplayBuilder
implements DisplayBuilder {
    private String text;
    private Matrix4f transformation;
    private Integer brightness;
    private Color glowColor;
    private Float viewRange;
    private Display.Billboard billboard;
    private TextDisplay.TextAlignment alignment;
    private Color backgroundColor;

    public TextDisplay build(@NotNull Location location) {
        return (TextDisplay)location.getWorld().spawn(location, TextDisplay.class, display -> {
            if (this.text != null) {
                display.setText(this.text);
            }
            if (this.transformation != null) {
                display.setTransformationMatrix(this.transformation);
            }
            if (this.brightness != null) {
                display.setBrightness(new Display.Brightness(this.brightness.intValue(), 0));
            }
            if (this.glowColor != null) {
                display.setGlowing(true);
                display.setGlowColorOverride(this.glowColor);
            }
            if (this.viewRange != null) {
                display.setViewRange(this.viewRange.floatValue());
            }
            if (this.billboard != null) {
                display.setBillboard(this.billboard);
            }
            if (this.alignment != null) {
                display.setAlignment(this.alignment);
            }
            if (this.backgroundColor != null) {
                display.setBackgroundColor(this.backgroundColor);
            }
            display.setDisplayWidth(0.0f);
            display.setDisplayHeight(0.0f);
        });
    }

    public TextDisplayBuilder text(String text) {
        this.text = text;
        return this;
    }

    public TextDisplayBuilder transformation(Matrix4f transformation) {
        this.transformation = transformation;
        return this;
    }

    public TextDisplayBuilder brightness(int brightness) {
        this.brightness = brightness;
        return this;
    }

    public TextDisplayBuilder glow(Color glowColor) {
        this.glowColor = glowColor;
        return this;
    }

    public TextDisplayBuilder viewRange(float viewRange) {
        this.viewRange = Float.valueOf(viewRange);
        return this;
    }

    public TextDisplayBuilder billboard(Display.Billboard billboard) {
        this.billboard = billboard;
        return this;
    }

    public TextDisplayBuilder alignment(TextDisplay.TextAlignment alignment) {
        this.alignment = alignment;
        return this;
    }

    public TextDisplayBuilder backgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }
}

