/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.buildingstaff.implementation;

import com.balugaq.buildingstaff.core.managers.CommandManager;
import com.balugaq.buildingstaff.core.managers.ConfigManager;
import com.balugaq.buildingstaff.core.managers.DisplayManager;
import com.balugaq.buildingstaff.core.managers.ListenerManager;
import com.balugaq.buildingstaff.core.managers.StaffSetup;
import com.balugaq.buildingstaff.utils.Debug;
import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.libraries.dough.updater.BlobBuildUpdater;
import java.text.MessageFormat;
import lombok.Generated;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class BuildingStaffPlugin
extends JavaPlugin
implements SlimefunAddon {
    private static BuildingStaffPlugin instance;
    private CommandManager commandManager;
    private ConfigManager configManager;
    private DisplayManager displayManager;
    private ListenerManager listenerManager;
    private StaffSetup staffSetup;
    private String username;
    private String repo;
    private String branch;

    public static BuildingStaffPlugin getInstance() {
        return instance;
    }

    public void onLoad() {
        instance = this;
    }

    public void onEnable() {
        Debug.log("Enabling BuildingStaff...");
        this.username = "balugaq";
        this.repo = "BuildingStaff";
        this.branch = "master";
        Debug.log("Loading config...");
        this.configManager = new ConfigManager(this);
        this.configManager.setup();
        Debug.log("Loading display manager...");
        this.displayManager = new DisplayManager(this);
        this.displayManager.setup();
        Debug.log("Loading listener manager...");
        this.listenerManager = new ListenerManager(this);
        this.listenerManager.setup();
        Debug.log("Loading command manager...");
        this.commandManager = new CommandManager(this);
        this.commandManager.setup();
        Debug.log("Trying to update...");
        if (this.getConfigManager().isAutoUpdate() && this.getDescription().getVersion().startsWith("DEV - ")) {
            new BlobBuildUpdater((Plugin)this, this.getFile(), "BuildingStaff", "Dev").start();
        }
        Debug.log("Registering BuildingStaff Items...");
        this.staffSetup = new StaffSetup(this);
        this.staffSetup.setup();
        Debug.log("BuildingStaff enabled!");
    }

    public void reload() {
        this.onDisable();
        this.onEnable();
    }

    public void onDisable() {
        Debug.log("\u6b63\u5728\u5378\u8f7d BuildingStaff...");
        this.staffSetup.shutdown();
        this.displayManager.shutdown();
        this.listenerManager.shutdown();
        this.commandManager.shutdown();
        this.configManager.shutdown();
        Debug.log("BuildingStaff \u5df2\u5378\u8f7d!");
    }

    @NotNull
    public JavaPlugin getJavaPlugin() {
        return this;
    }

    public String getBugTrackerURL() {
        return MessageFormat.format("https://github.com/{0}/{1}/issues", this.username, this.repo);
    }

    @Generated
    public CommandManager getCommandManager() {
        return this.commandManager;
    }

    @Generated
    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    @Generated
    public DisplayManager getDisplayManager() {
        return this.displayManager;
    }

    @Generated
    public ListenerManager getListenerManager() {
        return this.listenerManager;
    }

    @Generated
    public StaffSetup getStaffSetup() {
        return this.staffSetup;
    }
}

