/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.metalib.yaml;

import java.io.File;
import java.io.IOException;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.metamechanists.metalib.yaml.YamlSaveRunnable;
import org.metamechanists.metalib.yaml.YamlTraverser;

public class WriteableYaml {
    private static final long savePeriod = 18000L;
    private final Plugin plugin;
    private final File file;
    private final YamlConfiguration config;

    public WriteableYaml(Plugin plugin, File file, boolean savePeriodically) {
        this.plugin = plugin;
        this.file = file;
        this.config = YamlConfiguration.loadConfiguration((File)file);
        if (savePeriodically) {
            new YamlSaveRunnable(this).runTaskTimer(plugin, 0L, 18000L);
        }
    }

    public WriteableYaml(Plugin plugin, String path, boolean savePeriodically) {
        this(plugin, new File(plugin.getDataFolder(), path), savePeriodically);
    }

    public YamlTraverser getTraverser() {
        return new YamlTraverser(this.plugin, (ConfigurationSection)this.config, this.file.getName());
    }

    public void createIfNotExists() {
        if (!this.file.exists()) {
            try {
                this.file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void save() {
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public File getFile() {
        return this.file;
    }
}

