/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.buildingstaff.core.managers;

import com.balugaq.buildingstaff.api.interfaces.IManager;
import com.balugaq.buildingstaff.api.items.BreakingStaff;
import com.balugaq.buildingstaff.api.items.BuildingStaff;
import com.balugaq.buildingstaff.api.objects.events.PrepareBreakingEvent;
import com.balugaq.buildingstaff.api.objects.events.PrepareBuildingEvent;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.FluidCollisionMode;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.metamechanists.displaymodellib.sefilib.entity.display.DisplayGroup;

public class DisplayManager
implements IManager {
    private final Map<UUID, BlockFace> lookingFaces = new HashMap<UUID, BlockFace>();
    private final Map<UUID, Location> lookingAt = new HashMap<UUID, Location>();
    private final Map<UUID, DisplayGroup> displays = new HashMap<UUID, DisplayGroup>();
    private final JavaPlugin plugin;
    private boolean running = true;

    public DisplayManager(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void setup() {
        this.startShowBlockTask();
    }

    @Override
    public void shutdown() {
        this.stopShowBlockTask();
    }

    public void stopShowBlockTask() {
        this.running = false;
        for (UUID uuid : new HashSet<UUID>(this.displays.keySet())) {
            this.killDisplays(uuid);
        }
    }

    public void killDisplays(UUID uuid) {
        DisplayGroup group = this.displays.get(uuid);
        if (group != null) {
            group.remove();
        }
        this.displays.remove(uuid);
        this.lookingAt.remove(uuid);
        this.lookingFaces.remove(uuid);
    }

    public void startShowBlockTask() {
        Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            if (!this.running) {
                return;
            }
            for (Player player : Bukkit.getOnlinePlayers()) {
                BreakingStaff breakingStaff;
                PlayerEvent event;
                if (player.getGameMode() == GameMode.SPECTATOR) {
                    return;
                }
                UUID uuid = player.getUniqueId();
                Block block = player.getTargetBlockExact(6, FluidCollisionMode.NEVER);
                if (block == null || block.getType().isAir()) {
                    this.lookingAt.remove(uuid);
                    this.killDisplays(uuid);
                    continue;
                }
                BlockFace originalFacing = player.getTargetBlockFace(6, FluidCollisionMode.NEVER);
                if (originalFacing == null) {
                    this.lookingAt.remove(uuid);
                    this.lookingFaces.remove(uuid);
                    this.killDisplays(uuid);
                    continue;
                }
                Location location = block.getLocation();
                if (this.lookingAt.containsKey(uuid) && this.lookingAt.get(uuid).equals((Object)location) && this.lookingFaces.containsKey(uuid) && this.lookingFaces.get(uuid).equals((Object)originalFacing)) continue;
                this.killDisplays(uuid);
                this.lookingAt.put(uuid, location);
                this.lookingFaces.put(uuid, originalFacing);
                SlimefunItem staffLike = SlimefunItem.getByItem((ItemStack)player.getInventory().getItemInMainHand());
                if (staffLike instanceof BuildingStaff) {
                    BuildingStaff buildingStaff = (BuildingStaff)staffLike;
                    if (buildingStaff.isDisabledIn(block.getWorld()) || buildingStaff.isDisabledMaterial(block.getType())) continue;
                    event = new PrepareBuildingEvent(player, buildingStaff, block);
                    Bukkit.getPluginManager().callEvent((Event)event);
                }
                if (!(staffLike instanceof BreakingStaff) || (breakingStaff = (BreakingStaff)staffLike).isDisabledIn(block.getWorld()) || breakingStaff.isDisabledMaterial(block.getType())) continue;
                event = new PrepareBreakingEvent(player, breakingStaff, block);
                Bukkit.getPluginManager().callEvent((Event)event);
            }
        }, 2L, 1L);
    }

    public void registerDisplayGroup(UUID uuid, DisplayGroup group) {
        this.displays.put(uuid, group);
    }

    @Generated
    public Map<UUID, BlockFace> getLookingFaces() {
        return this.lookingFaces;
    }

    @Generated
    public Map<UUID, Location> getLookingAt() {
        return this.lookingAt;
    }

    @Generated
    public Map<UUID, DisplayGroup> getDisplays() {
        return this.displays;
    }

    @Generated
    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    @Generated
    public boolean isRunning() {
        return this.running;
    }
}

