/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.buildingstaff.core.listeners;

import com.balugaq.buildingstaff.api.items.BreakingStaff;
import com.balugaq.buildingstaff.api.objects.events.PrepareBreakingEvent;
import com.balugaq.buildingstaff.implementation.BuildingStaffPlugin;
import com.balugaq.buildingstaff.utils.Debug;
import com.balugaq.buildingstaff.utils.StaffUtil;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Display;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.metamechanists.displaymodellib.models.components.ModelCuboid;
import org.metamechanists.displaymodellib.sefilib.entity.display.DisplayGroup;

public class PrepareBreakingListener
implements Listener {
    private static final boolean DEBUG = BuildingStaffPlugin.getInstance().getConfigManager().isDebug();
    private static final boolean DISPLAY_PROJECTION = BuildingStaffPlugin.getInstance().getConfigManager().isDisplayProjection();
    private static final ModelCuboid border = new ModelCuboid().material(Material.RED_STAINED_GLASS).size(0.9f, 0.9f, 0.9f);

    @EventHandler
    public void onPrepareBreaking(@NotNull PrepareBreakingEvent event) {
        if (!DISPLAY_PROJECTION) {
            return;
        }
        Player player = event.getPlayer();
        Debug.debug("Preparing breaking blocks...");
        BreakingStaff breakingStaff = event.getBreakingStaff();
        this.showBreakingBlocksFor(player, event.getLookingAtBlock(), breakingStaff.getLimitBlocks(), breakingStaff);
    }

    private void showBreakingBlocksFor(@NotNull Player player, @NotNull Block lookingAtBlock, int limitBlocks, @NotNull BreakingStaff breakingStaff) {
        if (!player.isOp() && !Slimefun.getProtectionManager().hasPermission((OfflinePlayer)player, lookingAtBlock, Interaction.BREAK_BLOCK)) {
            return;
        }
        BlockFace originalFacing = player.getTargetBlockFace(6, FluidCollisionMode.NEVER);
        if (originalFacing == null) {
            return;
        }
        Material material = lookingAtBlock.getType();
        if (breakingStaff.isDisabledMaterial(material)) {
            return;
        }
        Location lookingLocation = lookingAtBlock.getLocation();
        ItemStack itemInMainHand = player.getInventory().getItemInMainHand();
        BlockFace lookingFacing = StaffUtil.getLookingFacing(originalFacing);
        Set<Location> rawLocations = StaffUtil.getRawLocations(lookingAtBlock, lookingFacing, limitBlocks, breakingStaff.getAxis(itemInMainHand), breakingStaff.isBlockStrict(), true);
        World world = lookingLocation.getWorld();
        HashMap<Location, Double> distances = new HashMap<Location, Double>();
        for (Location location : rawLocations) {
            if (!world.getWorldBorder().isInside(location)) continue;
            double distance = location.distance(lookingLocation);
            distances.put(location, distance);
        }
        HashSet locations = new HashSet(distances.keySet());
        List<Location> sortedLocations = locations.stream().sorted(Comparator.comparingDouble(distances::get)).limit(limitBlocks).toList();
        Vector vector = lookingFacing.getOppositeFace().getDirection().multiply(0.6).add(new Vector(0.5f, 0.5f, 0.5f));
        DisplayGroup displayGroup = new DisplayGroup(player.getLocation(), 0.0f, 0.0f);
        for (Location location : sortedLocations) {
            String ls = location.getBlockX() + "_" + location.getBlockY() + "_" + location.getBlockZ();
            Location displayLocation = location.clone().add(vector);
            displayGroup.addDisplay("b" + ls, (Display)border.build(displayLocation));
        }
        UUID uuid = player.getUniqueId();
        BuildingStaffPlugin.getInstance().getDisplayManager().registerDisplayGroup(uuid, displayGroup);
    }
}

