/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.metalib.utils;

import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;
import org.metamechanists.metalib.utils.RandomUtils;

public class ParticleUtils {
    private static final double[][] sphere = new double[84][];

    public static double[][] getSphere() {
        return sphere;
    }

    private static Vector generateRandomOffset(boolean setRandom) {
        return setRandom ? new Vector(RandomUtils.randomDouble(), RandomUtils.randomDouble(), RandomUtils.randomDouble()) : new Vector();
    }

    public static void randomParticle(Location location, Particle particle, double radius, int count) {
        for (int i = 0; i < count; ++i) {
            ParticleUtils.randomParticle(location, particle, radius);
        }
    }

    public static void randomParticle(Location location, Particle particle, double radius) {
        double x = ThreadLocalRandom.current().nextDouble(-radius, radius + 0.1);
        double y = ThreadLocalRandom.current().nextDouble(-radius, radius + 0.1);
        double z = ThreadLocalRandom.current().nextDouble(-radius, radius + 0.1);
        location.getWorld().spawnParticle(particle, location.clone().add(x, y, z), 0, 0.0, 0.0, 0.0, 0.0);
    }

    @ParametersAreNonnullByDefault
    public static void drawLine(Player player, Particle particle, Location start, Location end, double space, @Nullable Particle.DustOptions dustOptions) {
        double distance = start.distance(end);
        Vector startVector = start.toVector();
        Vector endVector = end.toVector();
        Vector vector = endVector.clone().subtract(startVector).normalize().multiply(space);
        for (double currentPoint = 0.0; currentPoint < distance; currentPoint += space) {
            if (dustOptions != null) {
                player.spawnParticle(particle, startVector.getX(), startVector.getY(), startVector.getZ(), 1, (Object)dustOptions);
            } else {
                player.spawnParticle(particle, startVector.getX(), startVector.getY(), startVector.getZ(), 1);
            }
            startVector.add(vector);
        }
    }

    public static void highlightBlock(Player player, Block block, Particle particle, Particle.DustOptions dustOptions) {
        ParticleUtils.drawSquareCorners(player, block.getLocation(), 1, particle, dustOptions);
        ParticleUtils.drawSquareCorners(player, block.getLocation().add(0.0, 1.0, 0.0), 1, particle, dustOptions);
    }

    public static void drawSquareCorners(Player player, Location corner, int length, Particle particle, Particle.DustOptions dustOptions) {
        player.spawnParticle(particle, corner.getX(), corner.getY(), corner.getZ(), 1, (Object)dustOptions);
        player.spawnParticle(particle, corner.getX() + (double)length, corner.getY(), corner.getZ(), 1, (Object)dustOptions);
        player.spawnParticle(particle, corner.getX() + (double)length, corner.getY(), corner.getZ() + (double)length, 1, (Object)dustOptions);
        player.spawnParticle(particle, corner.getX(), corner.getY(), corner.getZ() + (double)length, 1, (Object)dustOptions);
    }

    public static void sphereIn(Location location, Particle particle) {
        ParticleUtils.sphereIn(location, particle, 1.0, false);
    }

    public static void sphereIn(Location location, Particle particle, double speed) {
        ParticleUtils.sphereIn(location, particle, speed, false);
    }

    public static void sphereIn(Location location, Particle particle, boolean randomOffset) {
        ParticleUtils.sphereIn(location, particle, 1.0, randomOffset);
    }

    public static void sphereIn(Location location, Particle particle, double speed, boolean randomOffset) {
        World world = location.getWorld();
        for (double[] offsets : sphere) {
            Location particleLocation = location.clone().add(offsets[0], offsets[1], offsets[2]).add(ParticleUtils.generateRandomOffset(randomOffset));
            Vector direction = location.clone().subtract(particleLocation.clone()).toVector();
            world.spawnParticle(particle, particleLocation, 0, direction.getX(), direction.getY(), direction.getZ(), speed);
        }
    }

    public static void spheresUp(Location location, Particle particle) {
        World world = location.getWorld();
        double[] speeds = new double[]{0.1, 0.15, 0.2, 0.25};
        for (double[] offsets : sphere) {
            world.spawnParticle(particle, location.clone().add(offsets[0], offsets[1], offsets[2]), 0, 0.0, 5.0, 0.0, speeds[new Random().nextInt(0, speeds.length)]);
        }
    }

    public static void sphereOut(Location location, Particle particle) {
        ParticleUtils.sphereOut(location, particle, 0.25, false);
    }

    public static void sphereOut(Location location, Particle particle, double speed) {
        ParticleUtils.sphereOut(location, particle, speed, false);
    }

    public static void sphereOut(Location location, Particle particle, boolean randomOffset) {
        ParticleUtils.sphereOut(location, particle, 0.25, randomOffset);
    }

    public static void sphereOut(Location location, Particle particle, double speed, boolean randomOffset) {
        World world = location.getWorld();
        location = location.clone().add(0.0, 0.5, 0.0);
        for (double[] offsets : sphere) {
            Location particleLocation = location.clone().add(offsets[0], offsets[1], offsets[2]).add(ParticleUtils.generateRandomOffset(randomOffset));
            Vector direction = particleLocation.clone().subtract(location.clone()).toVector();
            world.spawnParticle(particle, particleLocation, 0, direction.getX(), direction.getY(), direction.getZ(), speed);
        }
    }

    public static void sphere(Location location, Particle particle, double scale, boolean randomOffset) {
        World world = location.getWorld();
        location = location.clone().add(0.0, 0.5, 0.0);
        for (double[] offsets : sphere) {
            Location particleLocation = location.clone().add(offsets[0] * scale, offsets[1] * scale, offsets[2] * scale).add(ParticleUtils.generateRandomOffset(randomOffset));
            world.spawnParticle(particle, particleLocation, 0, 0.0, 0.0, 0.0);
        }
    }

    static {
        int sphereLoc = 0;
        for (double i = 0.0; i <= Math.PI; i += 0.5235987755982988) {
            double radius = Math.sin(i);
            double y = Math.cos(i);
            for (double a = 0.0; a < Math.PI * 2; a += 0.5235987755982988) {
                double x = Math.cos(a) * radius;
                double z = Math.sin(a) * radius;
                ParticleUtils.sphere[sphereLoc] = new double[]{x, y, z};
                ++sphereLoc;
            }
        }
    }
}

