/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.displaymodellib.builders;

import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Display;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.metamechanists.displaymodellib.builders.DisplayBuilder;

public class BlockDisplayBuilder
implements DisplayBuilder {
    private Material material;
    private BlockData blockData;
    private Matrix4f transformation;
    private Color glowColor;
    private Integer brightness;
    private Float viewRange;

    public BlockDisplay build(@NotNull Location location) {
        return (BlockDisplay)location.getWorld().spawn(location, BlockDisplay.class, display -> {
            if (this.material != null) {
                display.setBlock(this.material.createBlockData());
            }
            if (this.blockData != null) {
                display.setBlock(this.blockData);
            }
            if (this.transformation != null) {
                display.setTransformationMatrix(this.transformation);
            }
            if (this.glowColor != null) {
                display.setGlowing(true);
                display.setGlowColorOverride(this.glowColor);
            }
            if (this.brightness != null) {
                display.setBrightness(new Display.Brightness(this.brightness.intValue(), 0));
            }
            if (this.viewRange != null) {
                display.setViewRange(this.viewRange.floatValue());
            }
            display.setDisplayWidth(0.0f);
            display.setDisplayHeight(0.0f);
        });
    }

    public BlockDisplayBuilder material(Material material) {
        this.material = material;
        return this;
    }

    public BlockDisplayBuilder blockData(BlockData blockData) {
        this.blockData = blockData;
        return this;
    }

    public BlockDisplayBuilder transformation(Matrix4f transformation) {
        this.transformation = transformation;
        return this;
    }

    public BlockDisplayBuilder brightness(int brightness) {
        this.brightness = brightness;
        return this;
    }

    public BlockDisplayBuilder glow(Color glowColor) {
        this.glowColor = glowColor;
        return this;
    }

    public BlockDisplayBuilder viewRange(float viewRange) {
        this.viewRange = Float.valueOf(viewRange);
        return this;
    }
}

