/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.metalib.yaml;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class YamlTraverser {
    private final Plugin plugin;
    private final ConfigurationSection section;
    private final String rootName;

    public YamlTraverser(Plugin plugin, ConfigurationSection section, String rootName) {
        this.plugin = plugin;
        this.section = section;
        this.rootName = rootName;
    }

    public YamlTraverser(Plugin plugin, File file) {
        this.plugin = plugin;
        this.section = YamlConfiguration.loadConfiguration((File)file);
        this.rootName = file.getName();
    }

    public YamlTraverser(Plugin plugin, String path) {
        this.plugin = plugin;
        this.section = YamlConfiguration.loadConfiguration((File)new File(plugin.getDataFolder(), path));
        this.rootName = path;
    }

    private void logMissingKey(String key) {
        this.plugin.getLogger().severe("Could not find " + this.rootName + "." + this.section.getCurrentPath() + "." + key);
    }

    @Nullable
    public YamlTraverser getSection(String key, ErrorSetting errorSetting) {
        if (errorSetting == ErrorSetting.LOG_MISSING_KEY && this.section.getConfigurationSection(key) == null) {
            this.logMissingKey(key);
        }
        return new YamlTraverser(this.plugin, this.section.getConfigurationSection(key), this.rootName);
    }

    @Nullable
    public YamlTraverser getSection(String key) {
        return this.getSection(key, ErrorSetting.LOG_MISSING_KEY);
    }

    public List<YamlTraverser> getSections() {
        ArrayList<YamlTraverser> list = new ArrayList<YamlTraverser>();
        for (String key : this.section.getKeys(false)) {
            list.add(new YamlTraverser(this.plugin, this.section.getConfigurationSection(key), this.rootName));
        }
        return list;
    }

    public String name() {
        return this.section.getName();
    }

    @Nullable
    public <T> T get(String key, ErrorSetting errorSetting) {
        if (errorSetting == ErrorSetting.LOG_MISSING_KEY && this.section.get(key) == null) {
            this.logMissingKey(key);
        }
        return (T)this.section.get(key);
    }

    @NonNull
    public <T> T get(String key, T defaultValue) {
        ErrorSetting value = this.get(key, (T)((Object)ErrorSetting.NO_BEHAVIOUR));
        if (value == null) {
            value = defaultValue;
        }
        return (T)((Object)value);
    }

    @Nullable
    public <T> T get(String key) {
        return (T)((Object)this.get(key, (T)((Object)ErrorSetting.LOG_MISSING_KEY)));
    }

    public <T> void set(String key, T value) {
        this.section.set(key, value);
    }

    public static enum ErrorSetting {
        LOG_MISSING_KEY,
        NO_BEHAVIOUR;

    }
}

