/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.buildingstaff.core.listeners;

import com.balugaq.buildingstaff.api.items.BuildingStaff;
import com.balugaq.buildingstaff.api.objects.events.PrepareBuildingEvent;
import com.balugaq.buildingstaff.implementation.BuildingStaffPlugin;
import com.balugaq.buildingstaff.utils.Debug;
import com.balugaq.buildingstaff.utils.StaffUtil;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import java.util.Set;
import java.util.UUID;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Display;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.metamechanists.displaymodellib.models.components.ModelCuboid;
import org.metamechanists.displaymodellib.sefilib.entity.display.DisplayGroup;

public class PrepareBuildingListener
implements Listener {
    private static final boolean DEBUG = BuildingStaffPlugin.getInstance().getConfigManager().isDebug();
    private static final boolean DISPLAY_PROJECTION = BuildingStaffPlugin.getInstance().getConfigManager().isDisplayProjection();
    private static final ModelCuboid blockBase = new ModelCuboid().size(0.6f, 0.6f, 0.6f);
    private static final ModelCuboid border = new ModelCuboid().material(Material.LIGHT_GRAY_STAINED_GLASS).size(0.7f, 0.7f, 0.7f);

    @EventHandler
    public void onPrepareBuilding(@NotNull PrepareBuildingEvent event) {
        if (!DISPLAY_PROJECTION) {
            return;
        }
        Player player = event.getPlayer();
        Debug.debug("Preparing building blocks...");
        BuildingStaff buildingStaff = event.getBuildingStaff();
        if (buildingStaff.isOpOnly() && !player.isOp()) {
            return;
        }
        this.showBuildingBlocksFor(player, event.getLookingAtBlock(), buildingStaff.getLimitBlocks(), event.getBuildingStaff());
    }

    private void showBuildingBlocksFor(@NotNull Player player, @NotNull Block lookingAtBlock, int limitBlocks, @NotNull BuildingStaff buildingStaff) {
        if (!player.isOp() && !Slimefun.getProtectionManager().hasPermission((OfflinePlayer)player, lookingAtBlock, Interaction.PLACE_BLOCK)) {
            return;
        }
        Material material = lookingAtBlock.getType();
        int playerHas = 0;
        if (player.getGameMode() == GameMode.CREATIVE) {
            playerHas = 4096;
        } else {
            for (ItemStack itemStack : player.getInventory().getStorageContents()) {
                if (itemStack == null || itemStack.getType() == Material.AIR) continue;
                if (itemStack.getType() == material) {
                    int count = itemStack.getAmount();
                    playerHas += count;
                }
                if (playerHas >= limitBlocks) break;
            }
        }
        Set<Location> showingBlocks = StaffUtil.getBuildingLocations(player, Math.min(limitBlocks, playerHas), buildingStaff.getAxis(player.getInventory().getItemInMainHand()), buildingStaff.isBlockStrict());
        DisplayGroup displayGroup = new DisplayGroup(player.getLocation(), 0.0f, 0.0f);
        for (Location location : showingBlocks) {
            String ls = location.getBlockX() + "_" + location.getBlockY() + "_" + location.getBlockZ();
            Location displayLocation = location.clone().add(0.5, 0.5, 0.5);
            displayGroup.addDisplay("m" + ls, (Display)blockBase.material(material).build(displayLocation));
            displayGroup.addDisplay("b" + ls, (Display)border.build(displayLocation));
        }
        displayGroup.getDisplays().forEach((name, display) -> display.setMetadata(BuildingStaffPlugin.getInstance().getName(), (MetadataValue)new FixedMetadataValue((Plugin)BuildingStaffPlugin.getInstance(), (Object)true)));
        UUID uuid = player.getUniqueId();
        BuildingStaffPlugin.getInstance().getDisplayManager().registerDisplayGroup(uuid, displayGroup);
    }
}

