/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.displaymodellib.models.components;

import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.BlockDisplay;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.metamechanists.displaymodellib.builders.BlockDisplayBuilder;
import org.metamechanists.displaymodellib.models.components.ModelComponent;
import org.metamechanists.displaymodellib.transformations.TransformationMatrixBuilder;

public class ModelDiamond
implements ModelComponent {
    public static final Vector3d ROTATION = new Vector3d(-0.955, 0.785, 0.0);
    private final BlockDisplayBuilder main = new BlockDisplayBuilder();
    private Vector3f location = new Vector3f();
    private Vector3f facing = new Vector3f(0.0f, 0.0f, 1.0f);
    private Vector3f size = new Vector3f();

    public ModelDiamond location(@NotNull Vector3f location) {
        this.location = location;
        return this;
    }

    public ModelDiamond location(float x, float y, float z) {
        return this.location(new Vector3f(x, y, z));
    }

    public ModelDiamond facing(@NotNull Vector3f facing) {
        this.facing = facing;
        return this;
    }

    public ModelDiamond facing(@NotNull BlockFace face) {
        return this.facing(face.getDirection().toVector3f());
    }

    public ModelDiamond size(float size) {
        this.size = new Vector3f((float)Math.sqrt(2.0 * Math.pow(size / 2.0f, 2.0)));
        return this;
    }

    public ModelDiamond block(@NotNull BlockData block) {
        this.main.blockData(block);
        return this;
    }

    public ModelDiamond material(@NotNull Material material) {
        this.main.material(material);
        return this;
    }

    public ModelDiamond brightness(int blockBrightness) {
        this.main.brightness(blockBrightness);
        return this;
    }

    public ModelDiamond glow(@NotNull Color color) {
        this.main.glow(color);
        return this;
    }

    public Matrix4f getMatrix() {
        return new TransformationMatrixBuilder().lookAlong(this.facing).translate(this.location).rotate(ROTATION).scale(this.size).buildForBlockDisplay();
    }

    public BlockDisplay build(@NotNull Location origin) {
        return this.main.transformation(this.getMatrix()).build(origin);
    }

    public BlockDisplay build(@NotNull Block block) {
        return this.build(block.getLocation());
    }
}

