/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.metalib.sefilib.entity.display.builders;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.entity.Display;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.inventory.ItemStack;
import org.metamechanists.metalib.sefilib.entity.display.DisplayGroup;
import org.metamechanists.metalib.sefilib.entity.display.builders.DisplayBuilder;

public class ItemDisplayBuilder
extends DisplayBuilder<ItemDisplayBuilder> {
    protected ItemStack itemStack;
    protected ItemDisplay.ItemDisplayTransform itemDisplayTransform;

    public ItemDisplayBuilder setItemStack(@Nullable ItemStack itemStack) {
        this.itemStack = itemStack;
        return this;
    }

    public ItemDisplayBuilder setItemDisplayTransform(@Nonnull ItemDisplay.ItemDisplayTransform itemDisplayTransform) {
        this.itemDisplayTransform = itemDisplayTransform;
        return this;
    }

    public ItemDisplay build() {
        if (this.location == null) {
            throw new IllegalStateException("You must provide a location for the Display Entity");
        }
        return this.generateDisplay(this.location);
    }

    public ItemDisplay build(@Nonnull DisplayGroup group) {
        if (this.groupParentOffset == null) {
            throw new IllegalStateException("You must provide a Group Parent Offset vector");
        }
        return this.generateDisplay(group.getLocation().clone().add(this.groupParentOffset));
    }

    private ItemDisplay generateDisplay(@Nonnull Location location) {
        ItemDisplay display = (ItemDisplay)location.getWorld().spawnEntity(location, EntityType.ITEM_DISPLAY);
        display.setItemStack(this.itemStack);
        if (this.itemDisplayTransform != null) {
            display.setItemDisplayTransform(this.itemDisplayTransform);
        }
        this.applyDisplay((Display)display);
        return display;
    }
}

