/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.metalib.utils;

import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.inventory.MainHand;
import org.bukkit.util.Vector;

public class LocationUtils {
    public static Location getLeftSide(Location location, double distance) {
        return location.clone().add(LocationUtils.getSideVector(location, distance));
    }

    public static Location getRightSide(Location location, double distance) {
        return location.clone().subtract(LocationUtils.getSideVector(location, distance));
    }

    public static Vector getSideVector(Location location, double distance) {
        float angle = (float)Math.toRadians(location.getYaw());
        return new Vector(Math.cos(angle), 0.0, Math.sin(angle)).normalize().multiply(distance);
    }

    public static Location getMainHandLocation(Player player) {
        return LocationUtils.getHandLocation(player, player.getMainHand() == MainHand.LEFT);
    }

    public static Location getOffHandLocation(Player player) {
        return LocationUtils.getHandLocation(player, player.getMainHand() == MainHand.RIGHT);
    }

    public static Location getHandLocation(Player player, boolean isLeftHand) {
        double y = 1.2 - (player.isSneaking() ? 0.4 : 0.0);
        Location playerLocation = player.getLocation();
        Location baseLocation = isLeftHand ? LocationUtils.getLeftSide(playerLocation, 0.55) : LocationUtils.getRightSide(playerLocation, 0.55);
        return baseLocation.add(0.0, y, 0.0).add(playerLocation.getDirection().multiply(0.8));
    }
}

