/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.metalib.dough.skins;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.plugin.Plugin;
import org.metamechanists.metalib.dough.common.DoughLogger;
import org.metamechanists.metalib.dough.skins.CustomGameProfile;

public final class PlayerSkin {
    private static final String ERROR_TOKEN = "error";
    private final CustomGameProfile profile;

    PlayerSkin(@Nonnull UUID uuid, @Nullable String base64skinTexture) {
        this.profile = new CustomGameProfile(uuid, base64skinTexture);
    }

    @Nonnull
    final CustomGameProfile getProfile() {
        return this.profile;
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public static PlayerSkin fromBase64(UUID uuid, String base64skinTexture) {
        return new PlayerSkin(uuid, base64skinTexture);
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public static PlayerSkin fromBase64(String base64skinTexture) {
        UUID uuid = UUID.nameUUIDFromBytes(base64skinTexture.getBytes(StandardCharsets.UTF_8));
        return PlayerSkin.fromBase64(uuid, base64skinTexture);
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public static PlayerSkin fromURL(UUID uuid, String url) {
        String value = "{\"textures\":{\"SKIN\":{\"url\":\"" + url + "\"}}}";
        String base64skinTexture = Base64.getEncoder().encodeToString(value.getBytes(StandardCharsets.UTF_8));
        return PlayerSkin.fromBase64(uuid, base64skinTexture);
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public static PlayerSkin fromURL(String url) {
        UUID uuid = UUID.nameUUIDFromBytes(url.getBytes(StandardCharsets.UTF_8));
        return PlayerSkin.fromURL(uuid, url);
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public static PlayerSkin fromHashCode(UUID uuid, String hashCode) {
        return PlayerSkin.fromURL(uuid, "http://textures.minecraft.net/texture/" + hashCode);
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public static PlayerSkin fromHashCode(String hashCode) {
        UUID uuid = UUID.nameUUIDFromBytes(hashCode.getBytes(StandardCharsets.UTF_8));
        return PlayerSkin.fromHashCode(uuid, hashCode);
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public static CompletableFuture<PlayerSkin> fromPlayerUUID(Plugin plugin, UUID uuid) {
        CompletableFuture<PlayerSkin> future = new CompletableFuture<PlayerSkin>();
        DoughLogger logger = new DoughLogger(plugin.getServer(), "skins");
        plugin.getServer().getScheduler().runTaskAsynchronously(plugin, () -> {
            block12: {
                String targetUrl = "https://sessionserver.mojang.com/session/minecraft/profile/" + uuid.toString().replace("-", "") + "?unsigned=false";
                try (InputStreamReader reader = new InputStreamReader(new URL(targetUrl).openStream(), StandardCharsets.UTF_8);){
                    JsonElement element = new JsonParser().parse((Reader)reader);
                    if (element instanceof JsonNull) break block12;
                    JsonObject obj = element.getAsJsonObject();
                    if (obj.has(ERROR_TOKEN)) {
                        String error = obj.get(ERROR_TOKEN).getAsString();
                        future.completeExceptionally(new UnsupportedOperationException(error));
                        return;
                    }
                    JsonArray properties = obj.get("properties").getAsJsonArray();
                    for (JsonElement el : properties) {
                        if (!el.isJsonObject() || !el.getAsJsonObject().get("name").getAsString().equals("textures")) continue;
                        String base64Texture = el.getAsJsonObject().get("value").getAsString();
                        PlayerSkin playerSkin = PlayerSkin.fromBase64(uuid, base64Texture);
                        future.complete(playerSkin);
                        return;
                    }
                }
                catch (MalformedURLException e) {
                    logger.log(Level.SEVERE, "Malformed sessions url: {0}", targetUrl);
                    future.completeExceptionally(e);
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "Exception while requesting skin: {0}", targetUrl);
                    future.completeExceptionally(e);
                }
            }
        });
        return future;
    }
}

