/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.buildingstaff.utils;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.bukkit.Axis;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StaffUtil {
    public static final Set<BlockFace> validFaces = new HashSet<BlockFace>();

    @NotNull
    public static Set<Location> getBuildingLocations(@NotNull Player player, int limitBlocks, Axis onlyAxis, boolean blockStrict) {
        if (limitBlocks <= 0) {
            return new HashSet<Location>();
        }
        Block lookingBlock = player.getTargetBlockExact(6, FluidCollisionMode.NEVER);
        if (lookingBlock == null || lookingBlock.getType().isAir()) {
            return new HashSet<Location>();
        }
        BlockFace originalFacing = player.getTargetBlockFace(6, FluidCollisionMode.NEVER);
        if (originalFacing == null) {
            return new HashSet<Location>();
        }
        BlockFace lookingFacing = StaffUtil.getLookingFacing(originalFacing);
        return StaffUtil.getLocations(lookingBlock, lookingFacing, limitBlocks, onlyAxis, blockStrict);
    }

    @NotNull
    public static BlockFace getLookingFacing(@NotNull BlockFace originalFacing) {
        BlockFace lookingFacing = originalFacing.getOppositeFace();
        if (!originalFacing.isCartesian()) {
            switch (originalFacing) {
                case NORTH_EAST: 
                case NORTH_WEST: 
                case NORTH_NORTH_EAST: 
                case NORTH_NORTH_WEST: {
                    lookingFacing = BlockFace.NORTH;
                    break;
                }
                case SOUTH_EAST: 
                case SOUTH_WEST: 
                case SOUTH_SOUTH_EAST: 
                case SOUTH_SOUTH_WEST: {
                    lookingFacing = BlockFace.SOUTH;
                    break;
                }
                case EAST_NORTH_EAST: 
                case EAST_SOUTH_EAST: {
                    lookingFacing = BlockFace.EAST;
                    break;
                }
                case WEST_NORTH_WEST: 
                case WEST_SOUTH_WEST: {
                    lookingFacing = BlockFace.WEST;
                }
            }
        }
        return lookingFacing;
    }

    @NotNull
    public static Set<Location> getLocations(@NotNull Block lookingBlock, @NotNull BlockFace lookingFacing, int limitBlocks, Axis onlyAxis, boolean blockStrict) {
        Set<Location> rawLocations = StaffUtil.getRawLocations(lookingBlock, lookingFacing, limitBlocks, onlyAxis, blockStrict);
        HashSet<Location> outwardLocations = new HashSet<Location>();
        for (Location location : rawLocations) {
            Location outwardLocation = location.clone().add(lookingFacing.getOppositeFace().getDirection());
            Block outwardBlock = outwardLocation.getBlock();
            Material outwardType = outwardBlock.getType();
            if (outwardType != Material.AIR && outwardType != Material.WATER && outwardType != Material.LAVA) continue;
            outwardLocations.add(outwardLocation);
        }
        Location lookingLocation = lookingBlock.getLocation();
        World world = lookingLocation.getWorld();
        HashMap<Location, Double> distances = new HashMap<Location, Double>();
        for (Location location : outwardLocations) {
            if (!world.getWorldBorder().isInside(location)) continue;
            double distance = location.distance(lookingLocation);
            distances.put(location, distance);
        }
        HashSet locations = new HashSet(distances.keySet());
        List<Location> sortedLocations = locations.stream().sorted(Comparator.comparingDouble(distances::get)).limit(limitBlocks).toList();
        return new HashSet<Location>(sortedLocations);
    }

    @NotNull
    public static Set<Location> getRawLocations(@NotNull Block lookingBlock, @NotNull BlockFace lookingFacing, int limitBlocks) {
        return StaffUtil.getRawLocations(lookingBlock, lookingFacing, limitBlocks, null);
    }

    @NotNull
    public static Set<Location> getRawLocations(@NotNull Block lookingBlock, @NotNull BlockFace lookingFacing, int limitBlocks, Axis onlyAxis) {
        return StaffUtil.getRawLocations(lookingBlock, lookingFacing, limitBlocks, onlyAxis, true);
    }

    @NotNull
    public static Set<Location> getRawLocations(@NotNull Block lookingBlock, @NotNull BlockFace lookingFacing, int limitBlocks, Axis onlyAxis, boolean blockStrict) {
        return StaffUtil.getRawLocations(lookingBlock, lookingFacing, limitBlocks, onlyAxis, blockStrict, true);
    }

    @NotNull
    public static Set<Location> getRawLocations(@NotNull Block lookingBlock, @NotNull BlockFace lookingFacing, int limitBlocks, @Nullable Axis onlyAxis, boolean blockStrict, boolean checkOutward) {
        HashSet<Location> locations = new HashSet<Location>();
        LinkedList<Location> queue = new LinkedList<Location>();
        Location lookingLocation = lookingBlock.getLocation();
        queue.offer(lookingLocation);
        HashSet<BlockFace> faces = new HashSet<BlockFace>(validFaces);
        faces.remove(lookingFacing);
        faces.remove(lookingFacing.getOppositeFace());
        if (onlyAxis != null) {
            switch (onlyAxis) {
                case X: {
                    faces.remove(BlockFace.NORTH);
                    faces.remove(BlockFace.SOUTH);
                    faces.remove(BlockFace.UP);
                    faces.remove(BlockFace.DOWN);
                    break;
                }
                case Y: {
                    faces.remove(BlockFace.NORTH);
                    faces.remove(BlockFace.SOUTH);
                    faces.remove(BlockFace.EAST);
                    faces.remove(BlockFace.WEST);
                    break;
                }
                case Z: {
                    faces.remove(BlockFace.EAST);
                    faces.remove(BlockFace.WEST);
                    faces.remove(BlockFace.UP);
                    faces.remove(BlockFace.DOWN);
                }
            }
        }
        if (faces.isEmpty()) {
            return locations;
        }
        while (!queue.isEmpty() && limitBlocks > 0) {
            Location queuedLocation;
            Block currentBlock = ((Location)queue.poll()).getBlock();
            Material type = currentBlock.getType();
            if (type.isAir() || locations.contains(queuedLocation = currentBlock.getLocation())) continue;
            locations.add(queuedLocation);
            for (BlockFace face : faces) {
                Location blockLocation;
                Block outwardBlock;
                Material outwardType;
                Location location;
                Block block = currentBlock.getRelative(face);
                if (blockStrict && block.getType() != type || locations.contains(location = block.getLocation()) || checkOutward && (outwardType = (outwardBlock = block.getRelative(lookingFacing.getOppositeFace())).getType()) != Material.AIR && outwardType != Material.WATER && outwardType != Material.LAVA || StaffUtil.manhattanDistance(lookingLocation, blockLocation = block.getLocation()) >= limitBlocks) continue;
                queue.offer(blockLocation);
            }
        }
        return locations;
    }

    public static int manhattanDistance(@NotNull Location a, @NotNull Location b) {
        int dx = Math.abs(a.getBlockX() - b.getBlockX());
        int dy = Math.abs(a.getBlockY() - b.getBlockY());
        int dz = Math.abs(a.getBlockZ() - b.getBlockZ());
        return dx + dy + dz;
    }

    static {
        validFaces.add(BlockFace.NORTH);
        validFaces.add(BlockFace.SOUTH);
        validFaces.add(BlockFace.EAST);
        validFaces.add(BlockFace.WEST);
        validFaces.add(BlockFace.UP);
        validFaces.add(BlockFace.DOWN);
    }
}

