/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.buildingstaff.core.managers;

import com.balugaq.buildingstaff.api.interfaces.IManager;
import com.balugaq.buildingstaff.core.commands.SubCommand;
import com.balugaq.buildingstaff.core.commands.list.ClearProjectileCommand;
import com.balugaq.buildingstaff.core.commands.list.ReloadCommand;
import com.balugaq.buildingstaff.implementation.BuildingStaffPlugin;
import com.balugaq.buildingstaff.utils.Lang;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandManager
implements TabExecutor,
IManager {
    private final BuildingStaffPlugin plugin;
    private final List<SubCommand> subCommands = new ArrayList<SubCommand>();

    public CommandManager(BuildingStaffPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void setup() {
        this.subCommands.add(new ReloadCommand(this.plugin));
        this.subCommands.add(new ClearProjectileCommand(this.plugin));
        PluginCommand pluginCommand = this.plugin.getCommand("buildingstaff");
        if (pluginCommand != null) {
            pluginCommand.setExecutor((CommandExecutor)this);
        }
    }

    @Override
    public void shutdown() {
        PluginCommand pluginCommand = this.plugin.getCommand("buildingstaff");
        if (pluginCommand != null) {
            pluginCommand.setExecutor(null);
        }
        this.subCommands.clear();
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull @NotNull String @NotNull [] args) {
        if (!sender.isOp()) {
            sender.sendMessage(Lang.getCommandMessage("no-permission"));
            return false;
        }
        if (args.length == 0) {
            sender.sendMessage(Lang.getCommandMessage("usage"));
            return false;
        }
        for (SubCommand subCommand : this.subCommands) {
            if (!subCommand.getIdentifier().equalsIgnoreCase(args[0]) || !subCommand.onCommand(sender, command, label, args)) continue;
            return true;
        }
        sender.sendMessage(Lang.getCommandMessage("not-found"));
        return false;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull @NotNull String @NotNull [] args) {
        if (!sender.isOp()) {
            return null;
        }
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 0) {
            return completions;
        }
        if (args.length == 1) {
            for (SubCommand subCommand : this.subCommands) {
                completions.add(subCommand.getIdentifier());
            }
        } else {
            for (SubCommand subCommand : this.subCommands) {
                if (!subCommand.getIdentifier().equalsIgnoreCase(args[0])) continue;
                completions.addAll(subCommand.onTabComplete(sender, command, label, args));
            }
        }
        return completions;
    }

    @Generated
    public BuildingStaffPlugin getPlugin() {
        return this.plugin;
    }

    @Generated
    public List<SubCommand> getSubCommands() {
        return this.subCommands;
    }
}

