/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.displaymodellib.sefilib.block;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;

public final class BlockUtils {
    private BlockUtils() {
        throw new IllegalStateException("Utility class");
    }

    @Nullable
    public static BlockFace getTargetedBlockFace(@Nonnull Player player) {
        List lastTwoTargetBlocks = player.getLastTwoTargetBlocks(null, 100);
        if (lastTwoTargetBlocks.size() != 2 || !((Block)lastTwoTargetBlocks.get(1)).getType().isOccluding()) {
            return null;
        }
        Block targetBlock = (Block)lastTwoTargetBlocks.get(1);
        Block adjacentBlock = (Block)lastTwoTargetBlocks.get(0);
        return targetBlock.getFace(adjacentBlock);
    }

    public static boolean isSkullBlock(@Nonnull Block block) {
        return block.getType() == Material.PLAYER_HEAD || block.getType() == Material.PLAYER_WALL_HEAD;
    }
}

