/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.displaymodellib.builders;

import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Display;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.metamechanists.displaymodellib.builders.DisplayBuilder;

public class ItemDisplayBuilder
implements DisplayBuilder {
    private Material material;
    private ItemStack itemStack;
    private Matrix4f transformation;
    private Integer brightness;
    private Color glowColor;
    private Display.Billboard billboard;
    private Float viewRange;

    public ItemDisplay build(@NotNull Location location) {
        return (ItemDisplay)location.getWorld().spawn(location, ItemDisplay.class, display -> {
            if (this.material != null) {
                display.setItemStack(new ItemStack(this.material));
            }
            if (this.itemStack != null) {
                display.setItemStack(this.itemStack);
            }
            if (this.transformation != null) {
                display.setTransformationMatrix(this.transformation);
            }
            if (this.glowColor != null) {
                display.setGlowing(true);
                display.setGlowColorOverride(this.glowColor);
            }
            if (this.brightness != null) {
                display.setBrightness(new Display.Brightness(this.brightness.intValue(), 0));
            }
            if (this.billboard != null) {
                display.setBillboard(this.billboard);
            }
            if (this.viewRange != null) {
                display.setViewRange(this.viewRange.floatValue());
            }
            display.setDisplayWidth(0.0f);
            display.setDisplayHeight(0.0f);
        });
    }

    public ItemDisplayBuilder material(Material material) {
        this.material = material;
        return this;
    }

    public ItemDisplayBuilder itemStack(ItemStack itemStack) {
        this.itemStack = itemStack;
        return this;
    }

    public ItemDisplayBuilder transformation(Matrix4f transformation) {
        this.transformation = transformation;
        return this;
    }

    public ItemDisplayBuilder brightness(int brightness) {
        this.brightness = brightness;
        return this;
    }

    public ItemDisplayBuilder glow(Color glowColor) {
        this.glowColor = glowColor;
        return this;
    }

    public ItemDisplayBuilder billboard(Display.Billboard billboard) {
        this.billboard = billboard;
        return this;
    }

    public ItemDisplayBuilder viewRange(float viewRange) {
        this.viewRange = Float.valueOf(viewRange);
        return this;
    }
}

