/*
 * Decompiled with CFR 0.152.
 */
package me.mmmjjkx.betterChests.utils;

import it.unimi.dsi.fastutil.Pair;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public final class LanguageManager {
    private final Plugin plugin;
    private YamlConfiguration configuration;

    public LanguageManager(Plugin plugin) {
        this.plugin = plugin;
        this.loadLanguages();
    }

    private void loadLanguages() {
        File langFile;
        File pluginFolder = this.plugin.getDataFolder();
        URL fileURL = Objects.requireNonNull(this.plugin.getClass().getClassLoader().getResource("language/"));
        String jarPath = fileURL.toString().substring(0, fileURL.toString().indexOf("!/") + 2);
        try {
            URL jar = new URL(jarPath);
            JarURLConnection jarCon = (JarURLConnection)jar.openConnection();
            JarFile jarFile = jarCon.getJarFile();
            Enumeration<JarEntry> jarEntries = jarFile.entries();
            while (jarEntries.hasMoreElements()) {
                JarEntry entry = jarEntries.nextElement();
                String name = entry.getName();
                if (!name.startsWith("language/") || entry.isDirectory()) continue;
                String realName = name.replaceAll("language/", "");
                InputStream stream = this.plugin.getClass().getClassLoader().getResourceAsStream(name);
                try {
                    File destinationFile = new File(pluginFolder, "language/" + realName);
                    if (!destinationFile.exists() && stream != null) {
                        this.plugin.saveResource("language/" + realName, false);
                    }
                    this.completeLangFile(this.plugin, "language/" + realName);
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String lang = this.plugin.getConfig().getString("language");
        if (lang == null || lang.isBlank()) {
            lang = "en-US";
        }
        if (!(langFile = new File(pluginFolder, "language/" + lang + ".yml")).exists() && !(langFile = new File(pluginFolder, "language/" + (lang = "en-US") + ".yml")).exists()) {
            this.plugin.saveResource("language/en-US.yml", false);
        }
        this.configuration = YamlConfiguration.loadConfiguration((File)langFile);
    }

    public String getMsg(String key, MessageReplacement ... args) {
        String msg = this.configuration.getString(key);
        if (msg == null) {
            return key;
        }
        for (MessageReplacement arg : args) {
            msg = arg.parse(msg);
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)msg);
    }

    public List<String> getMsgList(String key, MessageReplacement ... args) {
        List msgList = this.configuration.getStringList(key);
        for (MessageReplacement arg : args) {
            msgList.replaceAll(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)arg.parse((String)s)));
        }
        return msgList;
    }

    private void completeLangFile(Plugin plugin, String resourceFile) {
        InputStream stream = plugin.getResource(resourceFile);
        File file = new File(plugin.getDataFolder(), resourceFile);
        if (!file.exists()) {
            if (stream != null) {
                plugin.saveResource(resourceFile, false);
                return;
            }
            plugin.getLogger().warning("File completion of '" + resourceFile + "' is failed.");
            return;
        }
        if (stream == null) {
            plugin.getLogger().warning("File completion of '" + resourceFile + "' is failed.");
            return;
        }
        try {
            InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);
            YamlConfiguration configuration = YamlConfiguration.loadConfiguration((Reader)reader);
            YamlConfiguration configuration2 = YamlConfiguration.loadConfiguration((File)file);
            Set keys = configuration.getKeys(true);
            for (String key : keys) {
                List list2;
                Object value = configuration.get(key);
                if (value instanceof List && (list2 = configuration2.getList(key)) == null) {
                    configuration2.set(key, value);
                    continue;
                }
                if (!configuration2.contains(key)) {
                    configuration2.set(key, value);
                }
                if (configuration.getComments(key).equals(configuration2.getComments(key))) continue;
                configuration2.setComments(key, configuration.getComments(key));
            }
            for (String key : configuration2.getKeys(true)) {
                if (!(configuration2.contains(key) & !configuration.contains(key))) continue;
                configuration2.set(key, null);
            }
            configuration2.save(file);
        }
        catch (Exception e) {
            e.printStackTrace();
            plugin.getLogger().warning("File completion of '" + resourceFile + "' is failed.");
        }
    }

    public static final class MessageReplacement
    implements Pair<String, String> {
        private final String key;
        private final String value;

        public MessageReplacement(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String parse(String msg) {
            return msg.replace("%" + this.key + "%", this.value);
        }

        public String left() {
            return this.key;
        }

        public String right() {
            return this.value;
        }
    }
}

