/*
 * Decompiled with CFR 0.152.
 */
package me.mmmjjkx.betterChests.items.cargo;

import io.github.sefiraat.networks.NetworkStorage;
import io.github.sefiraat.networks.network.NodeDefinition;
import io.github.sefiraat.networks.network.stackcaches.ItemRequest;
import io.github.sefiraat.networks.slimefun.network.NetworkPusher;
import io.github.sefiraat.networks.utils.StackUtils;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import it.unimi.dsi.fastutil.Pair;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.mmmjjkx.betterChests.BCGroups;
import me.mmmjjkx.betterChests.items.chests.SimpleDrawer;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.inventory.ItemStack;

public class NetworksDrawerPusher
extends NetworkPusher {
    public NetworksDrawerPusher(SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super((ItemGroup)BCGroups.CARGO, item, recipeType, recipe);
    }

    protected void onTick(@Nullable BlockMenu blockMenu, @Nonnull Block block) {
        super.onTick(blockMenu, block);
        if (blockMenu != null) {
            this.tryPushItem(blockMenu);
        }
    }

    private void tryPushItem(@Nonnull BlockMenu blockMenu) {
        NodeDefinition definition = (NodeDefinition)NetworkStorage.getAllNetworkObjects().get(blockMenu.getLocation());
        if (definition == null || definition.getNode() == null) {
            return;
        }
        BlockFace direction = this.getCurrentDirection(blockMenu);
        Location loc = blockMenu.getBlock().getRelative(direction).getLocation();
        SlimefunItem target = BlockStorage.check((Location)loc);
        if (target == null) {
            return;
        }
        if (!(target instanceof SimpleDrawer)) {
            return;
        }
        SimpleDrawer d = (SimpleDrawer)target;
        for (int itemSlot : this.getItemSlots()) {
            ItemStack testItem = blockMenu.getItemInSlot(itemSlot);
            if (testItem == null || testItem.getType() == Material.AIR) continue;
            ItemStack clone = testItem.clone();
            clone.setAmount(1);
            ItemRequest itemRequest = new ItemRequest(clone, clone.getMaxStackSize());
            ItemStack itemStack = d.getStoringItem(loc);
            if (!StackUtils.itemsMatch((ItemStack)itemRequest.getItemStack(), (ItemStack)itemStack)) {
                return;
            }
            ItemStack retrieved = definition.getNode().getRoot().getItemStack(itemRequest);
            if (retrieved == null) break;
            Pair<Boolean, Integer> result = d.addItem(loc, retrieved);
            if (definition.getNode().getRoot().isDisplayParticles()) {
                this.showParticle(blockMenu.getLocation(), direction);
            }
            if (((Boolean)result.first()).booleanValue() && (Integer)result.second() <= 0) break;
            definition.getNode().getRoot().addItemStack(retrieved);
            break;
        }
    }
}

