/*
 * Decompiled with CFR 0.152.
 */
package me.mmmjjkx.betterChests.utils;

import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemStackBuilder {
    private final ItemStack itemStack;

    public ItemStackBuilder(Material material, Consumer<ItemMeta> metaConsumer) {
        this.itemStack = new ItemStack(material);
        ItemMeta itemMeta = this.itemStack.getItemMeta();
        metaConsumer.accept(itemMeta);
        this.itemStack.setItemMeta(itemMeta);
    }

    public ItemStackBuilder(ItemStack itemStack, Consumer<ItemMeta> metaConsumer) {
        this.itemStack = itemStack;
        ItemMeta itemMeta = itemStack.getItemMeta();
        metaConsumer.accept(itemMeta);
        itemStack.setItemMeta(itemMeta);
    }

    public ItemStackBuilder(Material material, String displayName, String ... lore) {
        this.itemStack = new ItemStack(material);
        ItemMeta itemMeta = this.itemStack.getItemMeta();
        itemMeta.setDisplayName(displayName);
        itemMeta.setLore(Stream.of(lore).toList());
        this.itemStack.setItemMeta(itemMeta);
    }

    public ItemStackBuilder(Material material, String displayName, List<String> lore) {
        this.itemStack = new ItemStack(material);
        ItemMeta itemMeta = this.itemStack.getItemMeta();
        itemMeta.setDisplayName(displayName);
        itemMeta.setLore(lore);
        this.itemStack.setItemMeta(itemMeta);
    }

    public ItemStackBuilder setAmount(int amount) {
        this.itemStack.setAmount(amount);
        return this;
    }

    @Generated
    public ItemStack getItemStack() {
        return this.itemStack;
    }
}

