/*
 * Decompiled with CFR 0.152.
 */
package me.mmmjjkx.betterChests.items.chests.ie;

import io.github.thebusybiscuit.slimefun4.libraries.dough.common.ChatColors;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.ItemUtils;
import io.github.thebusybiscuit.slimefun4.utils.tags.SlimefunTag;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import me.mmmjjkx.betterChests.BetterChests;
import me.mmmjjkx.betterChests.items.chests.ie.IEStorageUnit;
import me.mmmjjkx.betterChests.utils.ItemStackBuilder;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.block.data.type.WallSign;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public final class IEStorageCache {
    private static final String EMPTY_DISPLAY_NAME = String.valueOf(ChatColor.WHITE) + "Empty";
    private static final String VOID_EXCESS_TRUE = ChatColors.color((String)"&7Void Excess:&e true");
    private static final String VOID_EXCESS_FALSE = ChatColors.color((String)"&7Void Excess:&e false");
    private static final String STORED_AMOUNT = "stored";
    private static final String VOID_EXCESS = "void_excess";
    private static final ItemStack EMPTY_ITEM = new ItemStackBuilder(Material.BARRIER, meta -> {
        meta.setDisplayName(String.valueOf(ChatColor.WHITE) + "Empty");
        meta.getPersistentDataContainer().set(IEStorageUnit.EMPTY_KEY, PersistentDataType.BYTE, (Object)1);
    }).getItemStack();
    private static final Pattern SPACE = Pattern.compile(" ");
    private final IEStorageUnit storageUnit;
    private final BlockMenu menu;
    private final String[] signDisplay = new String[2];
    private String displayName;
    private Material material;
    private ItemMeta meta;
    private boolean voidExcess;
    private int amount;
    private static final DecimalFormat FORMAT = new DecimalFormat("###,###,###,###,###,###.#");

    IEStorageCache(IEStorageUnit storageUnit, BlockMenu menu) {
        this.storageUnit = storageUnit;
        this.menu = menu;
        this.reloadData();
        if (this.isEmpty()) {
            this.setEmptyDisplayName();
            menu.replaceExistingItem(13, EMPTY_ITEM);
        } else {
            ItemStack display = menu.getItemInSlot(13);
            if (display != null) {
                ItemMeta copy = display.getItemMeta();
                if (copy.getPersistentDataContainer().has(IEStorageUnit.EMPTY_KEY, PersistentDataType.BYTE)) {
                    ItemStack output = menu.getItemInSlot(16);
                    if (output != null) {
                        this.setStored(output);
                        menu.replaceExistingItem(16, null);
                    } else {
                        menu.replaceExistingItem(13, EMPTY_ITEM);
                        this.setEmptyDisplayName();
                        this.amount = 0;
                    }
                } else {
                    this.load(display, copy);
                }
            }
        }
        menu.addMenuClickHandler(4, (p, slot, item, action) -> {
            this.voidExcess = !this.voidExcess;
            BlockStorage.addBlockInfo((Location)this.menu.getLocation(), (String)VOID_EXCESS, (String)(this.voidExcess ? "true" : null));
            ItemMeta meta = item.getItemMeta();
            List lore = meta.getLore();
            lore.set(1, this.voidExcess ? VOID_EXCESS_TRUE : VOID_EXCESS_FALSE);
            meta.setLore(lore);
            item.setItemMeta(meta);
            return false;
        });
        menu.addMenuClickHandler(22, (p, slot, item, action) -> {
            if (this.amount == 1) {
                if (action.isShiftClicked() && !action.isRightClicked()) {
                    this.depositAll(p);
                } else {
                    this.withdrawLast(p);
                }
            } else if (!this.isEmpty()) {
                if (action.isRightClicked()) {
                    if (action.isShiftClicked()) {
                        this.withdraw(p, this.amount - 1);
                    } else {
                        this.withdraw(p, Math.min(this.material.getMaxStackSize(), this.amount - 1));
                    }
                } else if (action.isShiftClicked()) {
                    this.depositAll(p);
                } else {
                    this.withdraw(p, 1);
                }
            }
            return false;
        });
        this.updateStatus();
    }

    public long getStored() {
        return this.amount;
    }

    private static boolean checkWallSign(Block sign, Block block) {
        return SlimefunTag.WALL_SIGNS.isTagged((Keyed)sign.getType()) && sign.getRelative(((WallSign)sign.getBlockData()).getFacing().getOppositeFace()).equals(block);
    }

    private void setDisplayName(String name) {
        String color;
        this.displayName = name;
        int len = name.length();
        if (len == 0) {
            this.signDisplay[0] = "";
            this.signDisplay[1] = "";
            return;
        }
        if (len >= 2 && name.charAt(0) == '\u00a7') {
            char second = name.charAt(1);
            color = len >= 14 && second == 'x' ? name.substring(0, 14) : new String(new char[]{'\u00a7', second});
        } else {
            color = null;
        }
        if (name.length() <= 15) {
            this.signDisplay[0] = color != null ? name : String.valueOf(ChatColor.WHITE) + name;
            this.signDisplay[1] = "";
            return;
        }
        String[] words = SPACE.split(name);
        int i = 1;
        StringBuilder firstLine = new StringBuilder();
        if (color == null) {
            firstLine.append(ChatColor.WHITE);
        }
        firstLine.append(words[0]);
        while (i < words.length && words[i].length() + firstLine.length() < 15) {
            firstLine.append(' ').append(words[i++]);
        }
        this.signDisplay[0] = firstLine.toString();
        if (i < words.length) {
            String first;
            StringBuilder secondLine = new StringBuilder();
            if ((first = words[i++]).length() <= 1 || first.charAt(0) != '\u00a7') {
                if (color == null) {
                    secondLine.append(ChatColor.WHITE);
                } else {
                    secondLine.append(color);
                }
            }
            secondLine.append(first);
            while (i < words.length) {
                secondLine.append(' ').append(words[i++]);
            }
            this.signDisplay[1] = secondLine.toString();
        } else {
            this.signDisplay[1] = "";
        }
    }

    private void setEmptyDisplayName() {
        this.displayName = EMPTY_DISPLAY_NAME;
        this.signDisplay[0] = EMPTY_DISPLAY_NAME;
        this.signDisplay[1] = "";
    }

    void destroy(BlockBreakEvent e, List<ItemStack> drops) {
        int add;
        ItemStack output = this.menu.getItemInSlot(16);
        if (output != null && this.matches(output) && (add = Math.min(this.storageUnit.max - this.amount, output.getAmount())) != 0) {
            this.amount += add;
            output.setAmount(output.getAmount() - add);
        }
        Block b = e.getBlock();
        ItemStack drop = this.storageUnit.getItem().clone();
        drop.setItemMeta(IEStorageUnit.saveToStack(drop.getItemMeta(), this.storageUnit.getDisplayingItem(b), this.displayName, this.amount));
        e.getPlayer().sendMessage(String.valueOf(ChatColor.GREEN) + "Stored items transferred to dropped item");
        drops.add(drop);
        b.removeMetadata("ie_item", (Plugin)BetterChests.INSTANCE);
    }

    void reloadData() {
        Config config = BlockStorage.getLocationInfo((Location)this.menu.getLocation());
        String amt = config.getString(STORED_AMOUNT);
        this.amount = amt == null ? 0 : Integer.parseInt(amt);
        this.voidExcess = "true".equals(config.getString(VOID_EXCESS));
    }

    void load(ItemStack stored, ItemMeta copy) {
        this.menu.replaceExistingItem(13, stored);
        copy.getPersistentDataContainer().remove(IEStorageUnit.DISPLAY_KEY);
        this.meta = copy.equals(Bukkit.getItemFactory().getItemMeta(stored.getType())) ? null : copy;
        this.setDisplayName(ItemUtils.getItemName((ItemStack)stored));
        this.material = stored.getType();
    }

    void input() {
        ItemStack input = this.menu.getItemInSlot(10);
        if (input == null) {
            return;
        }
        if (this.isEmpty()) {
            this.amount = input.getAmount();
            this.setStored(input);
            this.menu.replaceExistingItem(10, null, false);
        } else if (this.matches(input)) {
            if (this.voidExcess) {
                if (this.amount < this.storageUnit.max) {
                    this.amount = Math.min(this.amount + input.getAmount(), this.storageUnit.max);
                }
                input.setAmount(0);
            } else if (this.amount < this.storageUnit.max) {
                if (input.getAmount() + this.amount >= this.storageUnit.max) {
                    input.setAmount(input.getAmount() - (this.storageUnit.max - this.amount));
                    this.amount = this.storageUnit.max;
                } else {
                    this.amount += input.getAmount();
                    input.setAmount(0);
                }
            }
        }
    }

    private void output() {
        int amt;
        if (this.amount == 0) {
            return;
        }
        ItemStack outputSlot = this.menu.getItemInSlot(16);
        if (outputSlot == null) {
            if (this.amount == 1) {
                this.menu.replaceExistingItem(16, this.createItem(1), false);
                this.setEmpty();
            } else {
                int amt2 = Math.min(this.material.getMaxStackSize(), this.amount - 1);
                this.menu.replaceExistingItem(16, this.createItem(amt2), false);
                this.amount -= amt2;
            }
        } else if (this.amount > 1 && (amt = Math.min(this.material.getMaxStackSize() - outputSlot.getAmount(), this.amount - 1)) != 0 && this.matches(outputSlot)) {
            outputSlot.setAmount(outputSlot.getAmount() + amt);
            this.amount -= amt;
        }
    }

    void tick(Block block) {
        Block check;
        this.input();
        this.output();
        BlockStorage.addBlockInfo((Location)this.menu.getLocation(), (String)STORED_AMOUNT, (String)String.valueOf(this.amount));
        if (this.menu.hasViewer()) {
            this.updateStatus();
        }
        if (SlimefunTag.SIGNS.isTagged((Keyed)(check = block.getRelative(0, 1, 0)).getType()) || IEStorageCache.checkWallSign(check = block.getRelative(1, 0, 0), block) || IEStorageCache.checkWallSign(check = block.getRelative(-1, 0, 0), block) || IEStorageCache.checkWallSign(check = block.getRelative(0, 0, 1), block) || IEStorageCache.checkWallSign(check = block.getRelative(0, 0, -1), block)) {
            Sign sign = (Sign)check.getState();
            sign.setLine(0, this.signDisplay[0]);
            sign.setLine(1, this.signDisplay[1]);
            sign.setLine(2, String.valueOf(ChatColor.GRAY) + "------------");
            sign.setLine(3, ChatColor.YELLOW.toString() + this.amount);
            sign.update();
        }
    }

    private void updateStatus() {
        this.menu.replaceExistingItem(4, new ItemStackBuilder(Material.CYAN_STAINED_GLASS_PANE, meta -> {
            meta.setDisplayName(String.valueOf(ChatColor.AQUA) + "Status");
            ArrayList<Object> lore = new ArrayList<Object>();
            if (this.amount == 0) {
                lore.add(ChatColors.color((String)("&6Stored: &e0 / " + this.format(this.storageUnit.max) + " &7(0%)")));
            } else {
                lore.add(ChatColors.color((String)("&6Stored: &e" + this.format(this.amount) + " / " + this.format(this.storageUnit.max) + " &7(" + this.format((double)this.amount * 100.0 / (double)this.storageUnit.max) + "%)")));
            }
            lore.add(this.voidExcess ? VOID_EXCESS_TRUE : VOID_EXCESS_FALSE);
            lore.add(String.valueOf(ChatColor.GRAY) + "(Click to toggle)");
            meta.setLore(lore);
        }).getItemStack(), false);
    }

    private void setStored(ItemStack input) {
        this.meta = input.hasItemMeta() ? input.getItemMeta() : null;
        this.setDisplayName(ItemUtils.getItemName((ItemStack)input));
        this.material = input.getType();
        ItemMeta meta = input.getItemMeta();
        meta.getPersistentDataContainer().set(IEStorageUnit.DISPLAY_KEY, PersistentDataType.BYTE, (Object)1);
        input.setItemMeta(meta);
        input.setAmount(1);
        this.menu.replaceExistingItem(13, input);
        this.menu.getLocation().getBlock().setMetadata("ie_item", (MetadataValue)new FixedMetadataValue((Plugin)BetterChests.INSTANCE, (Object)input));
    }

    private void setEmpty() {
        this.setEmptyDisplayName();
        this.meta = null;
        this.material = null;
        this.menu.replaceExistingItem(13, EMPTY_ITEM);
        this.amount = 0;
        this.menu.getLocation().getBlock().removeMetadata("ie_item", (Plugin)BetterChests.INSTANCE);
    }

    boolean matches(ItemStack item) {
        return item.getType() == this.material && item.hasItemMeta() == (this.meta != null) && (this.meta == null || this.meta.equals(item.getItemMeta()));
    }

    private ItemStack createItem(int amount) {
        ItemStack item = new ItemStack(this.material, amount);
        if (this.meta != null) {
            item.setItemMeta(this.meta);
        }
        return item;
    }

    boolean isEmpty() {
        return this.amount == 0;
    }

    private void withdraw(Player p, int withdraw) {
        int amt;
        if (this.material.getMaxStackSize() == 64) {
            ItemStack remaining = p.getInventory().addItem(new ItemStack[]{this.createItem(withdraw)}).values().toArray(new ItemStack[0])[0];
            if (remaining != null) {
                if (remaining.getAmount() != withdraw) {
                    this.amount += remaining.getAmount() - withdraw;
                }
            } else {
                this.amount -= withdraw;
            }
            return;
        }
        PlayerInventory inv = p.getInventory();
        int toWithdraw = withdraw;
        do {
            amt = Math.min(this.material.getMaxStackSize(), toWithdraw);
            ItemStack remaining = inv.addItem(new ItemStack[]{this.createItem(amt)}).values().toArray(new ItemStack[0])[0];
            if (remaining == null) continue;
            toWithdraw -= amt - remaining.getAmount();
            break;
        } while ((toWithdraw -= amt) > 0);
        if (toWithdraw != withdraw) {
            this.amount += toWithdraw - withdraw;
        }
    }

    private void withdrawLast(Player p) {
        if (p.getInventory().addItem(new ItemStack[]{this.createItem(1)}).values().toArray(new ItemStack[0])[0] == null) {
            this.setEmpty();
        }
    }

    private void depositAll(Player p) {
        this.depositAll(p.getInventory().getStorageContents());
    }

    public void depositAll(ItemStack[] itemStacks) {
        this.depositAll(itemStacks, false);
    }

    public void depositAll(ItemStack[] itemStacks, boolean observeVoiding) {
        if (this.amount < this.storageUnit.max) {
            for (ItemStack item : itemStacks) {
                if (item == null || !this.matches(item)) continue;
                if (item.getAmount() + this.amount >= this.storageUnit.max) {
                    item.setAmount(item.getAmount() - (this.storageUnit.max - this.amount));
                    this.amount = this.storageUnit.max;
                    continue;
                }
                this.amount += item.getAmount();
                item.setAmount(0);
            }
        }
        if (observeVoiding && this.voidExcess) {
            for (ItemStack item : itemStacks) {
                if (item == null || !this.matches(item)) continue;
                item.setAmount(0);
            }
        }
    }

    private String format(double num) {
        return FORMAT.format(num);
    }

    public void amount(int amount) {
        this.amount = amount;
    }
}

