/*
 * Decompiled with CFR 0.152.
 */
package me.mmmjjkx.betterChests.items.tools;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.NotPlaceable;
import io.github.thebusybiscuit.slimefun4.core.attributes.Rechargeable;
import io.github.thebusybiscuit.slimefun4.core.handlers.ItemUseHandler;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.items.SimpleSlimefunItem;
import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import me.mmmjjkx.betterChests.BCGroups;
import me.mmmjjkx.betterChests.BetterChests;
import me.mmmjjkx.betterChests.items.chests.SimpleChest;
import me.mmmjjkx.betterChests.utils.MessageReplacement;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class ChestColorer
extends SimpleSlimefunItem<ItemUseHandler>
implements NotPlaceable,
Rechargeable {
    private static final ColorMaterials DEFAULT_COLOR = ColorMaterials.NoColor;
    private static final NamespacedKey COLOR_KEY = new NamespacedKey((Plugin)BetterChests.INSTANCE, "color");

    public ChestColorer(SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super((ItemGroup)BCGroups.TOOLS, item, recipeType, recipe);
    }

    public float getMaxItemCharge(ItemStack itemStack) {
        return 200.0f;
    }

    @NotNull
    public ItemUseHandler getItemHandler() {
        return e -> {
            e.cancel();
            Player p = e.getPlayer();
            boolean cycle = p.isSneaking();
            ItemStack item = e.getItem();
            Optional block = e.getClickedBlock();
            if (block.isPresent() && !Slimefun.getProtectionManager().hasPermission((OfflinePlayer)p, (Block)block.get(), Interaction.INTERACT_BLOCK)) {
                p.sendMessage("\u00a7cYou don't have permission to interact with this block.");
                return;
            }
            if (cycle) {
                int index = PersistentDataAPI.getOptionalInt((PersistentDataHolder)item.getItemMeta(), (NamespacedKey)COLOR_KEY).orElse(DEFAULT_COLOR.ordinal());
                int nextIndex = index + 1;
                if (nextIndex >= ColorMaterials.values().length) {
                    nextIndex = DEFAULT_COLOR.ordinal();
                }
                ColorMaterials color = ColorMaterials.values()[nextIndex];
                ItemMeta meta = item.getItemMeta();
                String currentColor = BetterChests.INSTANCE.getLang().getMsg("items.chest_color_changer.current_color", new MessageReplacement[0]);
                String colorName = BetterChests.INSTANCE.getLang().getMsg(color.getTranslationKey(), new MessageReplacement[0]);
                Component lore = LegacyComponentSerializer.legacyAmpersand().deserialize(currentColor + colorName).decoration(TextDecoration.ITALIC, false);
                List loreList = item.lore();
                loreList.set(3, lore);
                meta.lore(loreList);
                PersistentDataAPI.setInt((PersistentDataHolder)meta, (NamespacedKey)COLOR_KEY, (int)nextIndex);
                item.setItemMeta(meta);
                p.sendActionBar(lore);
            } else if (block.isPresent()) {
                Block b = (Block)block.get();
                SlimefunItem sfItem = BlockStorage.check((Block)b);
                if (sfItem instanceof SimpleChest) {
                    if (this.getItemCharge(item) >= 10.0f) {
                        this.removeItemCharge(item, 10.0f);
                        int index = PersistentDataAPI.getOptionalInt((PersistentDataHolder)item.getItemMeta(), (NamespacedKey)COLOR_KEY).orElse(DEFAULT_COLOR.ordinal());
                        ColorMaterials color = ColorMaterials.values()[index];
                        b.setType(color.getMaterial());
                    } else {
                        p.sendMessage(BetterChests.INSTANCE.getLang().getMsg("items.chest_color_changer.no_energy", new MessageReplacement[0]));
                    }
                }
            } else {
                p.sendMessage("\u00a7cYou need to right-click at a block to use this item.");
            }
        };
    }

    private static enum ColorMaterials {
        NoColor(Material.GLASS, "no_color"),
        White(Material.WHITE_STAINED_GLASS, "white"),
        Yellow(Material.YELLOW_STAINED_GLASS, "yellow"),
        Orange(Material.ORANGE_STAINED_GLASS, "orange"),
        Red(Material.RED_STAINED_GLASS, "red"),
        Blue(Material.BLUE_STAINED_GLASS, "blue"),
        Green(Material.GREEN_STAINED_GLASS, "green"),
        Lime(Material.LIME_STAINED_GLASS, "lime"),
        Pink(Material.PINK_STAINED_GLASS, "pink"),
        Purple(Material.PURPLE_STAINED_GLASS, "purple"),
        Brown(Material.BROWN_STAINED_GLASS, "brown"),
        Black(Material.BLACK_STAINED_GLASS, "black"),
        Gray(Material.GRAY_STAINED_GLASS, "gray"),
        LightGray(Material.LIGHT_GRAY_STAINED_GLASS, "light_gray"),
        Cyan(Material.CYAN_STAINED_GLASS, "cyan"),
        Magenta(Material.MAGENTA_STAINED_GLASS, "magenta"),
        LightBlue(Material.LIGHT_BLUE_STAINED_GLASS, "light_blue");

        private final Material material;
        private final String key;

        private ColorMaterials(Material material, String key) {
            this.material = material;
            this.key = key;
        }

        public String getTranslationKey() {
            return "items.chest_color_changer.colors." + this.key;
        }

        @Generated
        public Material getMaterial() {
            return this.material;
        }

        @Generated
        public String getKey() {
            return this.key;
        }
    }
}

