/*
 * Decompiled with CFR 0.152.
 */
package me.mmmjjkx.betterChests.items.tools;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.NotPlaceable;
import io.github.thebusybiscuit.slimefun4.core.handlers.ItemUseHandler;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.items.SimpleSlimefunItem;
import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import me.mmmjjkx.betterChests.BCGroups;
import me.mmmjjkx.betterChests.BetterChests;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class LocationRecorder
extends SimpleSlimefunItem<ItemUseHandler>
implements NotPlaceable {
    private static final NamespacedKey WORLD = new NamespacedKey((Plugin)BetterChests.INSTANCE, "world");
    private static final NamespacedKey X = new NamespacedKey((Plugin)BetterChests.INSTANCE, "pos_x");
    private static final NamespacedKey Y = new NamespacedKey((Plugin)BetterChests.INSTANCE, "pos_y");
    private static final NamespacedKey Z = new NamespacedKey((Plugin)BetterChests.INSTANCE, "pos_z");

    public LocationRecorder(SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super((ItemGroup)BCGroups.TOOLS, item, recipeType, recipe);
    }

    @NotNull
    public ItemUseHandler getItemHandler() {
        return e -> {
            e.cancel();
            Player p = e.getPlayer();
            boolean record = p.isSneaking();
            ItemStack self = e.getItem();
            if (record) {
                Optional b = e.getClickedBlock();
                if (b.isPresent()) {
                    Block block = (Block)b.get();
                    Location loc = block.getLocation();
                    ItemMeta meta = self.getItemMeta();
                    PersistentDataAPI.setString((PersistentDataHolder)meta, (NamespacedKey)WORLD, (String)loc.getWorld().getName());
                    PersistentDataAPI.setInt((PersistentDataHolder)meta, (NamespacedKey)X, (int)loc.getBlockX());
                    PersistentDataAPI.setInt((PersistentDataHolder)meta, (NamespacedKey)Y, (int)loc.getBlockY());
                    PersistentDataAPI.setInt((PersistentDataHolder)meta, (NamespacedKey)Z, (int)loc.getBlockZ());
                    Component newLore = LegacyComponentSerializer.legacyAmpersand().deserialize("&bX: &a" + loc.getBlockX() + " &bY: &a" + loc.getBlockY() + " &bZ: &a" + loc.getBlockZ()).decoration(TextDecoration.ITALIC, false);
                    List lore = meta.lore();
                    if (lore != null && lore.size() < 3) {
                        lore.add(Component.empty());
                        lore.add(newLore);
                    }
                    meta.lore(lore);
                    self.setItemMeta(meta);
                    p.sendMessage("\u00a7aLocation recorded!");
                } else {
                    p.sendMessage("\u00a7cYou need to be right-clicking at a block to record its location.");
                }
            } else {
                ItemMeta meta = self.getItemMeta();
                Optional world = PersistentDataAPI.getOptionalString((PersistentDataHolder)meta, (NamespacedKey)WORLD);
                OptionalInt x = PersistentDataAPI.getOptionalInt((PersistentDataHolder)meta, (NamespacedKey)X);
                OptionalInt y = PersistentDataAPI.getOptionalInt((PersistentDataHolder)meta, (NamespacedKey)Y);
                OptionalInt z = PersistentDataAPI.getOptionalInt((PersistentDataHolder)meta, (NamespacedKey)Z);
                if (world.isPresent() && x.isPresent() && y.isPresent() && z.isPresent()) {
                    Location loc = new Location(Bukkit.getWorld((String)((String)world.get())), (double)x.getAsInt(), (double)y.getAsInt(), (double)z.getAsInt());
                    if (!Slimefun.getProtectionManager().hasPermission((OfflinePlayer)p, loc, Interaction.INTERACT_BLOCK)) {
                        p.sendMessage("\u00a7cYou do not have permission to access this location.");
                        return;
                    }
                    BlockMenu menu = BlockStorage.getInventory((Location)loc);
                    if (menu != null) {
                        menu.open(new Player[]{p});
                    }
                } else {
                    p.sendMessage("\u00a7cYou haven't recorded a location yet.");
                }
            }
        };
    }
}

