/*
 * Decompiled with CFR 0.152.
 */
package me.mmmjjkx.betterChests.items.chests;

import io.github.thebusybiscuit.slimefun4.api.events.AndroidMineEvent;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import java.util.Collection;
import java.util.List;
import java.util.stream.IntStream;
import me.mmmjjkx.betterChests.BCGroups;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.interfaces.InventoryBlock;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class SimpleChest
extends SlimefunItem
implements InventoryBlock {
    private final int size;

    public SimpleChest(int size, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super((ItemGroup)BCGroups.STORAGES, item, recipeType, recipe);
        this.size = size;
        this.createPreset(this, bmp -> bmp.setSize(size));
        this.addItemHandler(new ItemHandler[]{new BlockBreakHandler(true, true){

            public void onPlayerBreak(@NotNull BlockBreakEvent e, @NotNull ItemStack i, @NotNull List<ItemStack> drops) {
                drops.clear();
                this.drop(e.getBlock());
            }

            public void onExplode(@NotNull Block b, @NotNull List<ItemStack> drops) {
                drops.clear();
                this.drop(b);
            }

            public void onAndroidBreak(@NotNull AndroidMineEvent e) {
                this.drop(e.getBlock());
            }

            private void drop(Block b) {
                BlockMenu menu = BlockStorage.getInventory((Block)b);
                menu.dropItems(b.getLocation(), SimpleChest.this.getSlots());
                World world = b.getWorld();
                ItemStack item = SimpleChest.this.getItem().clone();
                item.setType(b.getType());
                world.dropItemNaturally(b.getLocation(), item);
            }
        }});
    }

    @NotNull
    public Collection<ItemStack> getDrops() {
        return List.of();
    }

    public int[] getInputSlots() {
        return this.getSlots();
    }

    public int[] getOutputSlots() {
        return this.getInputSlots();
    }

    protected int[] getSlots() {
        return IntStream.range(0, this.size).toArray();
    }
}

