/*
 * Decompiled with CFR 0.152.
 */
package me.mmmjjkx.betterChests.items.chests;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.NotHopperable;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockPlaceHandler;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import io.github.thebusybiscuit.slimefun4.libraries.dough.inventory.InvUtils;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import it.unimi.dsi.fastutil.Pair;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.IntStream;
import lombok.Generated;
import me.mmmjjkx.betterChests.BCGroups;
import me.mmmjjkx.betterChests.BetterChests;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TranslatableComponent;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.TileState;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.entity.TextDisplay;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.metadata.Metadatable;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Transformation;
import org.jetbrains.annotations.NotNull;
import org.joml.AxisAngle4f;
import org.joml.Vector3f;

public class SimpleDrawer
extends SlimefunItem
implements NotHopperable {
    private final NamespacedKey ITEM_ENTITY = new NamespacedKey((Plugin)BetterChests.INSTANCE, "drawer_item_entity");
    private final NamespacedKey NAME_ENTITY = new NamespacedKey((Plugin)BetterChests.INSTANCE, "drawer_item_name_entity");
    private final NamespacedKey COUNT_ENTITY = new NamespacedKey((Plugin)BetterChests.INSTANCE, "drawer_item_count_entity");
    private final NamespacedKey FACING = new NamespacedKey((Plugin)BetterChests.INSTANCE, "drawer_facing");
    private final Map<Location, EntityContainer> entities = new HashMap<Location, EntityContainer>();
    private final long capacity;

    public SimpleDrawer(SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, long capacity) {
        super((ItemGroup)BCGroups.STORAGES, item, recipeType, recipe);
        this.capacity = capacity;
        this.addItemHandler(new ItemHandler[]{new BlockPlaceHandler(false){

            public void onPlayerPlace(@NotNull BlockPlaceEvent e) {
                Player p = e.getPlayer();
                BlockFace facing = p.getFacing();
                Block placed = e.getBlockPlaced();
                Location itemLoc = SimpleDrawer.this.getLocation(placed.getLocation(), facing);
                SimpleDrawer.this.entities.put(e.getBlock().getLocation(), SimpleDrawer.this.spawnEntity(itemLoc, e.getBlock(), facing));
            }
        }});
        this.addItemHandler(new ItemHandler[]{e -> {
            e.cancel();
            Player p = e.getPlayer();
            boolean taking = p.getInventory().getItemInMainHand().getType() == Material.AIR;
            Optional clickedBlock = e.getClickedBlock();
            if (clickedBlock.isEmpty()) {
                return;
            }
            Block clicked = (Block)clickedBlock.get();
            EntityContainer container = this.tryGetContainer(clicked.getLocation());
            PersistentDataAPI.setString((PersistentDataHolder)container.item, (NamespacedKey)this.ITEM_ENTITY, (String)container.item.getUniqueId().toString());
            PersistentDataAPI.setString((PersistentDataHolder)container.itemName, (NamespacedKey)this.NAME_ENTITY, (String)container.itemName.getUniqueId().toString());
            PersistentDataAPI.setString((PersistentDataHolder)container.itemCount, (NamespacedKey)this.COUNT_ENTITY, (String)container.itemCount.getUniqueId().toString());
            TileState state = (TileState)clicked.getState();
            PersistentDataAPI.setString((PersistentDataHolder)state, (NamespacedKey)this.ITEM_ENTITY, (String)container.item.getUniqueId().toString());
            PersistentDataAPI.setString((PersistentDataHolder)state, (NamespacedKey)this.NAME_ENTITY, (String)container.itemName.getUniqueId().toString());
            PersistentDataAPI.setString((PersistentDataHolder)state, (NamespacedKey)this.COUNT_ENTITY, (String)container.itemCount.getUniqueId().toString());
            state.update();
            if (!Slimefun.getProtectionManager().hasPermission((OfflinePlayer)p, clicked.getLocation(), Interaction.INTERACT_BLOCK)) {
                p.sendMessage("\u00a7cYou do not have permission to interact with this block.");
                return;
            }
            if (taking) {
                int count = Integer.parseInt(Objects.requireNonNull(container.itemCount.getText()));
                if (count == 0) {
                    p.sendMessage("\u00a7cThere is no item in this drawer.");
                    return;
                }
                PlayerInventory pinv = p.getInventory();
                ItemStack itemStack = Objects.requireNonNull(container.item.getItemStack());
                int maxStackSize = itemStack.getMaxStackSize();
                if (itemStack.isSimilar(pinv.getItemInMainHand())) {
                    ItemStack hand = pinv.getItemInMainHand();
                    int handCount = hand.getAmount();
                    int toTake = Math.min(count, maxStackSize - handCount);
                    container.itemName.text(SimpleDrawer.getItemName(itemStack));
                    container.itemCount.text((Component)Component.text((String)String.valueOf(count - toTake)));
                    if (count - toTake == 0) {
                        container.itemName.text((Component)Component.text((String)"Empty"));
                        container.item.setItemStack(new ItemStack(Material.BARRIER));
                    }
                    pinv.getItemInMainHand().setAmount(handCount + toTake);
                } else {
                    ItemStack beingGet = itemStack.clone();
                    int toTake = Math.min(count, maxStackSize);
                    beingGet.setAmount(toTake);
                    if (!InvUtils.fits((Inventory)pinv, (ItemStack)beingGet, (int[])IntStream.range(0, 36).toArray())) {
                        p.sendMessage("\u00a7cYour inventory is full.");
                        return;
                    }
                    container.itemName.text(SimpleDrawer.getItemName(itemStack));
                    container.itemCount.text((Component)Component.text((String)String.valueOf(count - toTake)));
                    if (count - toTake == 0) {
                        container.itemName.text((Component)Component.text((String)"Empty"));
                        container.item.setItemStack(new ItemStack(Material.BARRIER));
                    }
                    pinv.addItem(new ItemStack[]{beingGet});
                }
                p.updateInventory();
                this.storeItem(clicked.getLocation(), container.item.getItemStack(), Integer.parseInt(container.itemCount.getText()));
            } else {
                ItemStack handItem = p.getInventory().getItemInMainHand();
                if (handItem.getType() == Material.AIR || handItem.getAmount() < 1) {
                    p.sendMessage("\u00a7cYou need to hold an item in your main hand to place it in the drawer.");
                    return;
                }
                long count = Long.parseLong(Objects.requireNonNullElse(container.itemCount.getText(), "0"));
                if (count == 0L) {
                    container.itemName.text(SimpleDrawer.getItemName(handItem));
                    container.item.setItemStack(handItem.clone());
                    container.itemCount.text((Component)Component.text((int)handItem.getAmount()));
                    p.getInventory().setItemInMainHand(new ItemStack(Material.AIR));
                    p.updateInventory();
                    this.storeItem(clicked.getLocation(), container.item.getItemStack(), Integer.parseInt(Objects.requireNonNullElse(container.itemCount.getText(), "0")));
                    return;
                }
                ItemStack itemStack = Objects.requireNonNull(container.item.getItemStack());
                if (itemStack.isSimilar(handItem)) {
                    int handCount;
                    int toAdd = handCount = handItem.getAmount();
                    if (count == capacity) {
                        p.sendMessage("\u00a7cThis drawer is full.");
                        return;
                    }
                    if (count + (long)toAdd > capacity) {
                        toAdd = (int)(capacity - count);
                    }
                    handItem.setAmount(handCount - toAdd);
                    this.storeItem(clicked.getLocation(), container.item.getItemStack(), Integer.parseInt(container.itemCount.getText()));
                    p.updateInventory();
                    container.itemName.text(SimpleDrawer.getItemName(itemStack));
                    container.itemCount.text((Component)Component.text((long)(count + (long)toAdd)));
                } else {
                    p.sendMessage("\u00a7cThe drawer already contains other items.");
                }
            }
        }});
        this.addItemHandler(new ItemHandler[]{new BlockBreakHandler(false, false){

            public void onPlayerBreak(@NotNull BlockBreakEvent e, @NotNull ItemStack i, @NotNull List<ItemStack> drops) {
                Location itemLoc = e.getBlock().getLocation();
                Block block = e.getBlock();
                SimpleDrawer.this.tryGetContainer(itemLoc);
                EntityContainer container = SimpleDrawer.this.entities.remove(itemLoc);
                World w = block.getWorld();
                ItemStack stack = Objects.requireNonNullElseGet(container.item.getItemStack(), () -> {
                    List l1 = block.getMetadata("bc_drawer_item");
                    if (!l1.isEmpty()) {
                        return (ItemStack)((MetadataValue)l1.get(0)).value();
                    }
                    return new ItemStack(Material.AIR);
                });
                int count = Integer.parseInt(Objects.requireNonNullElseGet(container.itemCount.getText(), () -> {
                    List l2 = block.getMetadata("bc_drawer_count");
                    if (!l2.isEmpty()) {
                        return ((MetadataValue)l2.get(0)).asString();
                    }
                    return "0";
                }));
                if (stack.getType() == Material.BARRIER && count < 1) {
                    container.item.remove();
                    container.itemName.remove();
                    container.itemCount.remove();
                    return;
                }
                stack.setAmount(count);
                w.dropItemNaturally(itemLoc, stack);
                block.removeMetadata("bc_drawer_item", (Plugin)BetterChests.INSTANCE);
                block.removeMetadata("bc_drawer_count", (Plugin)BetterChests.INSTANCE);
                container.item.remove();
                container.itemName.remove();
                container.itemCount.remove();
            }
        }});
    }

    public static Component getItemName(ItemStack item) {
        if (item == null) {
            return Component.text((String)"Empty");
        }
        Component name = item.displayName();
        if (name instanceof TranslatableComponent) {
            TranslatableComponent tc = (TranslatableComponent)name;
            return (Component)tc.args().get(0);
        }
        return name;
    }

    private void storeItem(Location barrelLoc, ItemStack item, long count) {
        Block block = barrelLoc.getBlock();
        block.setMetadata("bc_drawer_item", (MetadataValue)new FixedMetadataValue((Plugin)BetterChests.INSTANCE, (Object)item.asOne()));
        block.setMetadata("bc_drawer_count", (MetadataValue)new FixedMetadataValue((Plugin)BetterChests.INSTANCE, (Object)count));
    }

    private EntityContainer tryGetContainer(Location barrelLoc) {
        Object countEntityUUID;
        Block block = barrelLoc.getBlock();
        if (this.entities.get(barrelLoc) != null) {
            EntityContainer container = this.entities.get(barrelLoc);
            if (!container.chunkLoaded()) {
                this.entities.remove(barrelLoc);
                long count = Long.parseLong(Objects.requireNonNullElse(container.itemCount.getText(), "0"));
                block.removeMetadata("bc_drawer_count", (Plugin)BetterChests.INSTANCE);
                block.setMetadata("bc_drawer_count", (MetadataValue)new FixedMetadataValue((Plugin)BetterChests.INSTANCE, (Object)count));
                return this.tryGetContainer(barrelLoc);
            }
            return container;
        }
        AtomicReference<ItemDisplay> itemA = new AtomicReference<ItemDisplay>();
        AtomicReference<TextDisplay> itemNameA = new AtomicReference<TextDisplay>();
        AtomicReference<TextDisplay> itemCountA = new AtomicReference<TextDisplay>();
        if (!block.getChunk().isEntitiesLoaded()) {
            block.getChunk().load();
        }
        for (Entity e : block.getChunk().getEntities()) {
            UUID countEntityUUIDBlock;
            BlockState blockState = block.getState();
            if (!(blockState instanceof TileState)) continue;
            TileState st = (TileState)blockState;
            if (e instanceof ItemDisplay && PersistentDataAPI.hasString((PersistentDataHolder)e, (NamespacedKey)this.ITEM_ENTITY)) {
                UUID itemUUIDBlock;
                UUID itemUUID = UUID.fromString(PersistentDataAPI.getString((PersistentDataHolder)e, (NamespacedKey)this.ITEM_ENTITY, (String)""));
                if (!itemUUID.equals(itemUUIDBlock = UUID.fromString(PersistentDataAPI.getString((PersistentDataHolder)st, (NamespacedKey)this.ITEM_ENTITY, (String)"")))) continue;
                itemA.set((ItemDisplay)e);
                continue;
            }
            if (e instanceof TextDisplay && PersistentDataAPI.hasString((PersistentDataHolder)e, (NamespacedKey)this.NAME_ENTITY)) {
                UUID itemNameUUIDBlock;
                UUID itemNameUUID = UUID.fromString(PersistentDataAPI.getString((PersistentDataHolder)e, (NamespacedKey)this.NAME_ENTITY, (String)""));
                if (!itemNameUUID.equals(itemNameUUIDBlock = UUID.fromString(PersistentDataAPI.getString((PersistentDataHolder)st, (NamespacedKey)this.NAME_ENTITY, (String)"")))) continue;
                itemNameA.set((TextDisplay)e);
                continue;
            }
            if (!(e instanceof TextDisplay) || !PersistentDataAPI.hasString((PersistentDataHolder)e, (NamespacedKey)this.COUNT_ENTITY) || !((UUID)(countEntityUUID = UUID.fromString(PersistentDataAPI.getString((PersistentDataHolder)e, (NamespacedKey)this.COUNT_ENTITY, (String)"")))).equals(countEntityUUIDBlock = UUID.fromString(PersistentDataAPI.getString((PersistentDataHolder)st, (NamespacedKey)this.COUNT_ENTITY, (String)"")))) continue;
            itemCountA.set((TextDisplay)e);
        }
        ItemDisplay item = (ItemDisplay)itemA.get();
        TextDisplay itemName = (TextDisplay)itemNameA.get();
        TextDisplay itemCount = (TextDisplay)itemCountA.get();
        if (item == null || itemName == null || itemCount == null) {
            int n;
            if (item != null) {
                item.remove();
            }
            if (itemName != null) {
                itemName.remove();
            }
            if (itemCount != null) {
                itemCount.remove();
            }
            if ((countEntityUUID = block.getState()) instanceof TileState) {
                TileState ts = (TileState)countEntityUUID;
                n = PersistentDataAPI.getInt((PersistentDataHolder)ts, (NamespacedKey)this.FACING, (int)0);
            } else {
                n = 0;
            }
            int ordinal = n;
            BlockFace face = BlockFace.values()[ordinal];
            EntityContainer container = this.spawnEntity(this.getLocation(barrelLoc, face), block, face);
            this.entities.put(barrelLoc, container);
            return container;
        }
        this.retainItem(block, item, itemName, itemCount);
        EntityContainer container = new EntityContainer(item, itemName, itemCount);
        this.entities.put(barrelLoc, container);
        return container;
    }

    private EntityContainer spawnEntity(Location itemLoc, Block block, BlockFace facing) {
        World w = block.getWorld();
        float rotationYaw = switch (facing) {
            case BlockFace.SOUTH -> -180.0f;
            case BlockFace.WEST -> -90.0f;
            case BlockFace.EAST -> 90.0f;
            default -> 0.0f;
        };
        ItemDisplay item = (ItemDisplay)w.spawn(itemLoc, ItemDisplay.class, i -> {
            i.setItemStack(new ItemStack(Material.BARRIER));
            i.setTransformation(this.getTransformation());
            i.setPersistent(true);
            i.setInvulnerable(true);
        });
        TextDisplay itemName = (TextDisplay)w.spawn(itemLoc.clone().add(0.0, 0.2, 0.001), TextDisplay.class, t -> {
            t.text((Component)Component.text((String)"Empty"));
            t.setPersistent(true);
            t.setInvulnerable(true);
            t.setVisibleByDefault(true);
            t.setAlignment(TextDisplay.TextAlignment.CENTER);
        });
        TextDisplay itemCount = (TextDisplay)w.spawn(itemLoc.clone().subtract(0.0, 0.5, -0.001), TextDisplay.class, t -> {
            t.text((Component)Component.text((int)0));
            t.setPersistent(true);
            t.setInvulnerable(true);
            t.setVisibleByDefault(true);
            t.setAlignment(TextDisplay.TextAlignment.CENTER);
        });
        PersistentDataAPI.setInt((PersistentDataHolder)((TileState)block.getState()), (NamespacedKey)this.FACING, (int)facing.ordinal());
        this.retainItem(block, item, itemName, itemCount);
        item.setRotation(rotationYaw, 0.0f);
        itemName.setRotation(rotationYaw, 0.0f);
        itemCount.setRotation(rotationYaw, 0.0f);
        return new EntityContainer(item, itemName, itemCount);
    }

    private void retainItem(Block block, ItemDisplay item, TextDisplay itemName, TextDisplay itemCount) {
        MetadataValue countValue;
        ItemStack itemStackValue;
        MetadataValue itemStack = this.getMetadata((Metadatable)block, "bc_drawer_item");
        if (itemStack != null && (itemStackValue = (ItemStack)itemStack.value()) != null && itemStackValue.getType() != Material.AIR) {
            item.setItemStack(itemStackValue);
            itemName.text(SimpleDrawer.getItemName(itemStackValue));
        }
        if ((countValue = this.getMetadata((Metadatable)block, "bc_drawer_count")) != null) {
            itemCount.text((Component)Component.text((String)String.valueOf(countValue.asLong())));
        }
    }

    private Transformation getTransformation() {
        Vector3f scale = new Vector3f(0.39f, 0.39f, 0.39f);
        return new Transformation(new Vector3f(), new AxisAngle4f(), scale, new AxisAngle4f());
    }

    private Location getLocation(Location barrelLoc, BlockFace facing) {
        return switch (facing) {
            case BlockFace.SOUTH -> barrelLoc.clone().add(0.5, 0.5, -0.002);
            case BlockFace.WEST -> barrelLoc.clone().add(1.005, 0.5, 0.5);
            case BlockFace.EAST -> barrelLoc.clone().add(0.0, 0.5, 0.502);
            default -> barrelLoc.clone().add(0.5, 0.5, 1.002);
        };
    }

    private MetadataValue getMetadata(Metadatable m, String key) {
        List metadata = m.getMetadata(key);
        return metadata.isEmpty() ? null : (MetadataValue)metadata.get(0);
    }

    public Pair<Boolean, Integer> addItem(Location barrelLoc, ItemStack item) {
        int toAdd;
        if (item.getType() == Material.AIR) {
            return Pair.of((Object)false, (Object)0);
        }
        if (item.getAmount() < 1) {
            return Pair.of((Object)false, (Object)0);
        }
        MetadataValue theItem = this.getMetadata((Metadatable)barrelLoc.getBlock(), "bc_drawer_item");
        EntityContainer container = this.entities.get(barrelLoc);
        if (container == null) {
            return Pair.of((Object)false, (Object)0);
        }
        if (theItem == null) {
            container.item.setItemStack(item.asOne().clone());
            container.itemName.text(SimpleDrawer.getItemName(item));
            container.itemCount.text((Component)Component.text((int)item.getAmount()));
            int toAdd2 = (int)Math.min((long)item.getAmount(), this.capacity > Integer.MAX_VALUE ? Integer.MAX_VALUE : this.capacity);
            item.setAmount(item.getAmount() - toAdd2);
            if (item.getAmount() < 1) {
                item.setType(Material.AIR);
            }
            this.storeItem(barrelLoc, item, item.getAmount());
            return Pair.of((Object)true, (Object)item.getAmount());
        }
        ItemStack drawerItem = (ItemStack)theItem.value();
        if (drawerItem == null || !drawerItem.isSimilar(item)) {
            return Pair.of((Object)false, (Object)0);
        }
        long drawerCount = 0L;
        MetadataValue countValue = this.getMetadata((Metadatable)barrelLoc.getBlock(), "bc_drawer_count");
        if (countValue != null) {
            drawerCount = countValue.asLong();
        }
        if (drawerCount + (long)(toAdd = item.getAmount()) > this.capacity) {
            toAdd = (int)(this.capacity - drawerCount);
        }
        item.setAmount(item.getAmount() - toAdd);
        if (item.getAmount() < 1) {
            item.setType(Material.AIR);
        }
        container.itemCount.text((Component)Component.text((long)(drawerCount + (long)toAdd)));
        this.storeItem(barrelLoc, drawerItem, drawerCount + (long)toAdd);
        return Pair.of((Object)true, (Object)item.getAmount());
    }

    public ItemStack getStoringItem(Location barrelLoc) {
        MetadataValue theItem = this.getMetadata((Metadatable)barrelLoc.getBlock(), "bc_drawer_item");
        if (this.entities.get(barrelLoc) == null || theItem == null) {
            return null;
        }
        ItemStack item = (ItemStack)theItem.value();
        if (item == null || item.getType() == Material.AIR) {
            return null;
        }
        return item.asOne();
    }

    public long getStoringItemCount(Location barrelLoc) {
        Block block = barrelLoc.getBlock();
        if (this.entities.get(barrelLoc) == null || this.getMetadata((Metadatable)block, "bc_drawer_item") == null) {
            return 0L;
        }
        MetadataValue countValue = this.getMetadata((Metadatable)block, "bc_drawer_count");
        EntityContainer container = this.entities.get(barrelLoc);
        if (container == null) {
            return countValue != null ? countValue.asLong() : 0L;
        }
        if (container.itemCount == null) {
            this.tryGetContainer(barrelLoc);
            container = this.entities.get(barrelLoc);
            String text = container.itemCount.getText();
            if (text == null) {
                return 0L;
            }
            return Long.parseLong(text);
        }
        String text = container.itemCount.getText();
        if (text == null) {
            return 0L;
        }
        return Long.parseLong(text);
    }

    public int getStoringItemCountSafely(Location barrelLoc) {
        return (int)Math.min(this.getStoringItemCount(barrelLoc), 0x7FFFFFFEL);
    }

    @CanIgnoreReturnValue
    public ItemStack takeItem(Location barrelLoc, int count) {
        EntityContainer container = this.entities.get(barrelLoc);
        if (container == null) {
            return null;
        }
        ItemStack item = container.item.getItemStack();
        if (item == null || item.getType() == Material.AIR) {
            return null;
        }
        if (count < 1) {
            return null;
        }
        int itemCount = 0;
        MetadataValue countValue = this.getMetadata((Metadatable)barrelLoc.getBlock(), "bc_drawer_count");
        if (countValue != null) {
            itemCount = countValue.asInt();
        }
        if (itemCount < 1) {
            return null;
        }
        if (count > itemCount) {
            return null;
        }
        ItemStack copy = item.clone();
        copy.setAmount(count);
        container.itemCount.text((Component)Component.text((int)(itemCount -= count)));
        if (itemCount == 0) {
            container.item.setItemStack(new ItemStack(Material.BARRIER));
            container.itemName.text((Component)Component.text((String)"Empty"));
        }
        this.storeItem(barrelLoc, item, itemCount);
        return copy;
    }

    @Generated
    public long getCapacity() {
        return this.capacity;
    }

    private record EntityContainer(ItemDisplay item, TextDisplay itemName, TextDisplay itemCount) {
        boolean chunkLoaded() {
            return this.item.getChunk().isLoaded() && this.item.isValid();
        }
    }
}

